/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

final class CloseFollowerIndexStep
extends AsyncRetryDuringSnapshotActionStep {
    static final String NAME = "close-follower-index";

    CloseFollowerIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentClusterState, AsyncActionStep.Listener listener) {
        String followerIndex = indexMetadata.getIndex().getName();
        Map customIndexMetadata = indexMetadata.getCustomData("ccr");
        if (customIndexMetadata == null) {
            listener.onResponse(true);
            return;
        }
        if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
            CloseIndexRequest closeIndexRequest = (CloseIndexRequest)new CloseIndexRequest(new String[]{followerIndex}).masterNodeTimeout(CloseFollowerIndexStep.getMasterTimeout(currentClusterState));
            this.getClient().admin().indices().close(closeIndexRequest, ActionListener.wrap(r -> {
                assert (r.isAcknowledged()) : "close index response is not acknowledged";
                listener.onResponse(true);
            }, listener::onFailure));
        } else {
            listener.onResponse(true);
        }
    }
}

