/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;

public abstract class AsyncActionStep
extends Step {
    private Client client;

    public AsyncActionStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey);
        this.client = client;
    }

    protected Client getClient() {
        return this.client;
    }

    public static TimeValue getMasterTimeout(ClusterState clusterState) {
        Objects.requireNonNull(clusterState, "cannot determine master timeout when cluster state is null");
        return (TimeValue)LifecycleSettings.LIFECYCLE_STEP_MASTER_TIMEOUT_SETTING.get(clusterState.metadata().settings());
    }

    public boolean indexSurvives() {
        return true;
    }

    public abstract void performAction(IndexMetadata var1, ClusterState var2, ClusterStateObserver var3, Listener var4);

    public static interface Listener {
        public void onResponse(boolean var1);

        public void onFailure(Exception var1);
    }
}

