/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.common.io.SqlStreamOutput;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggCursor;
import org.elasticsearch.xpack.sql.execution.search.PivotCursor;
import org.elasticsearch.xpack.sql.execution.search.ScrollCursor;
import org.elasticsearch.xpack.sql.execution.search.extractor.SqlBucketExtractors;
import org.elasticsearch.xpack.sql.execution.search.extractor.SqlHitExtractors;
import org.elasticsearch.xpack.sql.expression.function.scalar.Processors;
import org.elasticsearch.xpack.sql.expression.literal.Literals;
import org.elasticsearch.xpack.sql.plugin.TextFormatterCursor;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.ListCursor;

public final class Cursors {
    private static final NamedWriteableRegistry WRITEABLE_REGISTRY = new NamedWriteableRegistry(Cursors.getNamedWriteables());
    private static final Version VERSION = Version.CURRENT;

    private Cursors() {
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "0", in -> Cursor.EMPTY));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "s", ScrollCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "c", CompositeAggCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "p", PivotCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "f", TextFormatterCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "l", ListCursor::new));
        entries.addAll(Processors.getNamedWriteables());
        entries.addAll(SqlHitExtractors.getNamedWriteables());
        entries.addAll(SqlBucketExtractors.getNamedWriteables());
        entries.addAll(Literals.getNamedWriteables());
        return entries;
    }

    public static String encodeToString(Cursor info, ZoneId zoneId) {
        return Cursors.encodeToString(info, VERSION, zoneId);
    }

    static String encodeToString(Cursor info, Version version, ZoneId zoneId) {
        String string;
        if (info == Cursor.EMPTY) {
            return "";
        }
        SqlStreamOutput output = new SqlStreamOutput(version, zoneId);
        try {
            output.writeNamedWriteable(info);
            output.close();
            string = output.streamAsString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new SqlIllegalArgumentException("Unexpected failure retrieving next page", ex);
            }
        }
        output.close();
        return string;
    }

    public static Tuple<Cursor, ZoneId> decodeFromStringWithZone(String base64) {
        Tuple tuple;
        if (base64.isEmpty()) {
            return new Tuple((Object)Cursor.EMPTY, null);
        }
        SqlStreamInput in = new SqlStreamInput(base64, WRITEABLE_REGISTRY, VERSION);
        try {
            Cursor cursor = (Cursor)in.readNamedWriteable(Cursor.class);
            tuple = new Tuple((Object)cursor, (Object)in.zoneId());
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new SqlIllegalArgumentException("Unexpected failure decoding cursor", ex);
            }
        }
        in.close();
        return tuple;
    }
}

