/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.plugin.TextFormat;
import org.elasticsearch.xpack.sql.proto.Mode;

public class RestSqlQueryAction
extends BaseRestHandler {
    TextFormat textFormat;

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_sql", RestRequest.Method.GET, "/_xpack/sql"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_sql", RestRequest.Method.POST, "/_xpack/sql")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        SqlQueryRequest sqlRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            sqlRequest = SqlQueryRequest.fromXContent((XContentParser)parser);
        }
        String accept = null;
        accept = Mode.isDedicatedClient((Mode)sqlRequest.requestInfo().mode()) && (sqlRequest.binaryCommunication() == null || sqlRequest.binaryCommunication() != false) ? XContentType.CBOR.name() : request.param("format");
        if (accept == null && "*/*".equals(accept = request.header("Accept"))) {
            accept = null;
        }
        if (accept == null) {
            accept = request.header("Content-Type");
        }
        assert (accept != null) : "The Content-Type header is required";
        final XContentType xContentType = accept == null ? XContentType.JSON : XContentType.fromMediaTypeOrFormat((String)accept);
        TextFormat textFormat = this.textFormat = xContentType == null ? TextFormat.fromMediaTypeOrFormat(accept) : null;
        if (xContentType == null && sqlRequest.columnar().booleanValue()) {
            throw new IllegalArgumentException("Invalid use of [columnar] argument: cannot be used in combination with txt, csv or tsv formats");
        }
        final long startNanos = System.nanoTime();
        return channel -> client.execute((ActionType)SqlQueryAction.INSTANCE, (ActionRequest)sqlRequest, (ActionListener)new RestResponseListener<SqlQueryResponse>(channel){

            public RestResponse buildResponse(SqlQueryResponse response) throws Exception {
                BytesRestResponse restResponse;
                if (xContentType != null) {
                    XContentBuilder builder = this.channel.newBuilder(request.getXContentType(), xContentType, true);
                    response.toXContent(builder, (ToXContent.Params)request);
                    restResponse = new BytesRestResponse(RestStatus.OK, builder);
                } else {
                    String data = RestSqlQueryAction.this.textFormat.format(request, response);
                    restResponse = new BytesRestResponse(RestStatus.OK, RestSqlQueryAction.this.textFormat.contentType(request), data.getBytes(StandardCharsets.UTF_8));
                    if (response.hasCursor()) {
                        restResponse.addHeader("Cursor", response.cursor());
                    }
                }
                restResponse.addHeader("Took-nanos", Long.toString(System.nanoTime() - startNanos));
                return restResponse;
            }
        });
    }

    protected Set<String> responseParams() {
        return this.textFormat == TextFormat.CSV ? Collections.singleton("delimiter") : Collections.emptySet();
    }

    public String getName() {
        return "sql_query";
    }
}

