/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlSession;

public class ShowTables
extends Command {
    private final String index;
    private final LikePattern pattern;
    private final boolean includeFrozen;

    public ShowTables(Source source, String index, LikePattern pattern, boolean includeFrozen) {
        super(source);
        this.index = index;
        this.pattern = pattern;
        this.includeFrozen = includeFrozen;
    }

    protected NodeInfo<ShowTables> info() {
        return NodeInfo.create((Node)this, ShowTables::new, (Object)this.index, (Object)this.pattern, (Object)this.includeFrozen);
    }

    public String index() {
        return this.index;
    }

    public LikePattern pattern() {
        return this.pattern;
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(this.keyword("name"), this.keyword("type"), this.keyword("kind"));
    }

    @Override
    public final void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        String idx = this.index != null ? this.index : (this.pattern != null ? this.pattern.asIndexNameWildcard() : "*");
        String regex = this.pattern != null ? this.pattern.asJavaRegex() : null;
        EnumSet withFrozen = session.configuration().includeFrozen() || this.includeFrozen ? IndexResolver.IndexType.VALID_INCLUDE_FROZEN : IndexResolver.IndexType.VALID_REGULAR;
        session.indexResolver().resolveNames(idx, regex, withFrozen, ActionListener.wrap(result -> listener.onResponse((Object)this.of(session, result.stream().map(t -> Arrays.asList(t.name(), t.type().toSql(), t.type().toNative())).collect(Collectors.toList()))), arg_0 -> listener.onFailure(arg_0)));
    }

    public int hashCode() {
        return Objects.hash(this.index, this.pattern, this.includeFrozen);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowTables other = (ShowTables)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.pattern, other.pattern) && this.includeFrozen == other.includeFrozen;
    }
}

