/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.SqlArithmeticOperation;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.SqlBinaryArithmeticOperation;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class Mul
extends SqlArithmeticOperation {
    private DataType dataType;

    public Mul(Source source, Expression left, Expression right) {
        super(source, left, right, SqlBinaryArithmeticOperation.MUL);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        DataType l = this.left().dataType();
        DataType r = this.right().dataType();
        if (DataTypes.isNullOrNumeric((DataType)l) && DataTypes.isNullOrNumeric((DataType)r)) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (SqlDataTypes.isNullOrInterval(l) && (r.isInteger() || DataTypes.isNull((DataType)r))) {
            this.dataType = l;
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (SqlDataTypes.isNullOrInterval(r) && (l.isInteger() || DataTypes.isNull((DataType)l))) {
            this.dataType = r;
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] has arguments with incompatible types [{}] and [{}]", (Object[])new Object[]{this.symbol(), l, r}));
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = super.dataType();
        }
        return this.dataType;
    }

    protected NodeInfo<Mul> info() {
        return NodeInfo.create((Node)this, Mul::new, (Object)this.left(), (Object)this.right());
    }

    protected Mul replaceChildren(Expression newLeft, Expression newRight) {
        return new Mul(this.source(), newLeft, newRight);
    }
}

