/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.whitelist;

import java.time.Duration;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;
import org.elasticsearch.xpack.ql.expression.function.scalar.whitelist.InternalQlScriptUtils;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateAddProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateDiffProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DatePartProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFormatProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeParseProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTruncProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NamedDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NonIsoDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.QuarterProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.TimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.GeoProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StDistanceProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StWkttosqlProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryMathProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryOptionalMathProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.MathProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.BinaryStringNumericProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.BinaryStringStringProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ConcatFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.InsertFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LocateFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ReplaceFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.SubstringFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.literal.geo.GeoShape;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalDayTime;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalYearMonth;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.NullIfProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.SqlBinaryArithmeticOperation;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class InternalSqlScriptUtils
extends InternalQlScriptUtils {
    InternalSqlScriptUtils() {
    }

    public static Object coalesce(List<Object> expressions) {
        return ConditionalProcessor.ConditionalOperation.COALESCE.apply((Collection<Object>)expressions);
    }

    public static Object greatest(List<Object> expressions) {
        return ConditionalProcessor.ConditionalOperation.GREATEST.apply((Collection<Object>)expressions);
    }

    public static Object least(List<Object> expressions) {
        return ConditionalProcessor.ConditionalOperation.LEAST.apply((Collection<Object>)expressions);
    }

    public static Object nullif(Object left, Object right) {
        return NullIfProcessor.apply(left, right);
    }

    public static Object add(Object left, Object right) {
        return SqlBinaryArithmeticOperation.ADD.apply(left, right);
    }

    public static Object div(Object left, Object right) {
        return SqlBinaryArithmeticOperation.DIV.apply(left, right);
    }

    public static Object mod(Object left, Object right) {
        return SqlBinaryArithmeticOperation.MOD.apply(left, right);
    }

    public static Object mul(Object left, Object right) {
        return SqlBinaryArithmeticOperation.MUL.apply(left, right);
    }

    public static Object sub(Object left, Object right) {
        return SqlBinaryArithmeticOperation.SUB.apply(left, right);
    }

    public static Number round(Number v, Number s) {
        return BinaryOptionalMathProcessor.BinaryOptionalMathOperation.ROUND.apply(v, s);
    }

    public static Number truncate(Number v, Number s) {
        return BinaryOptionalMathProcessor.BinaryOptionalMathOperation.TRUNCATE.apply(v, s);
    }

    public static Number abs(Number value) {
        return MathProcessor.MathOperation.ABS.apply(value);
    }

    public static Number acos(Number value) {
        return MathProcessor.MathOperation.ACOS.apply(value);
    }

    public static Number asin(Number value) {
        return MathProcessor.MathOperation.ASIN.apply(value);
    }

    public static Number atan(Number value) {
        return MathProcessor.MathOperation.ATAN.apply(value);
    }

    public static Number atan2(Number left, Number right) {
        return BinaryMathProcessor.BinaryMathOperation.ATAN2.apply(left, right);
    }

    public static Number cbrt(Number value) {
        return MathProcessor.MathOperation.CBRT.apply(value);
    }

    public static Number ceil(Number value) {
        return MathProcessor.MathOperation.CEIL.apply(value);
    }

    public static Number cos(Number value) {
        return MathProcessor.MathOperation.COS.apply(value);
    }

    public static Number cosh(Number value) {
        return MathProcessor.MathOperation.COSH.apply(value);
    }

    public static Number cot(Number value) {
        return MathProcessor.MathOperation.COT.apply(value);
    }

    public static Number degrees(Number value) {
        return MathProcessor.MathOperation.DEGREES.apply(value);
    }

    public static Number e(Number value) {
        return MathProcessor.MathOperation.E.apply(value);
    }

    public static Number exp(Number value) {
        return MathProcessor.MathOperation.EXP.apply(value);
    }

    public static Number expm1(Number value) {
        return MathProcessor.MathOperation.EXPM1.apply(value);
    }

    public static Number floor(Number value) {
        return MathProcessor.MathOperation.FLOOR.apply(value);
    }

    public static Number log(Number value) {
        return MathProcessor.MathOperation.LOG.apply(value);
    }

    public static Number log10(Number value) {
        return MathProcessor.MathOperation.LOG10.apply(value);
    }

    public static Number pi(Number value) {
        return MathProcessor.MathOperation.PI.apply(value);
    }

    public static Number power(Number left, Number right) {
        return BinaryMathProcessor.BinaryMathOperation.POWER.apply(left, right);
    }

    public static Number radians(Number value) {
        return MathProcessor.MathOperation.RADIANS.apply(value);
    }

    public static Number random(Number value) {
        return MathProcessor.MathOperation.RANDOM.apply(value);
    }

    public static Number sign(Number value) {
        return MathProcessor.MathOperation.SIGN.apply(value);
    }

    public static Number sin(Number value) {
        return MathProcessor.MathOperation.SIN.apply(value);
    }

    public static Number sinh(Number value) {
        return MathProcessor.MathOperation.SINH.apply(value);
    }

    public static Number sqrt(Number value) {
        return MathProcessor.MathOperation.SQRT.apply(value);
    }

    public static Number tan(Number value) {
        return MathProcessor.MathOperation.TAN.apply(value);
    }

    public static Integer dateTimeChrono(Object dateTime, String tzId, String chronoName) {
        if (dateTime == null || tzId == null || chronoName == null) {
            return null;
        }
        if (dateTime instanceof OffsetTime) {
            return TimeFunction.dateTimeChrono((OffsetTime)dateTime, tzId, chronoName);
        }
        return DateTimeFunction.dateTimeChrono(InternalSqlScriptUtils.asDateTime(dateTime), tzId, chronoName);
    }

    public static String dayName(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return NamedDateTimeProcessor.NameExtractor.DAY_NAME.extract(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static Integer dayOfWeek(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return NonIsoDateTimeProcessor.NonIsoDateTimeExtractor.DAY_OF_WEEK.extract(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static String monthName(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return NamedDateTimeProcessor.NameExtractor.MONTH_NAME.extract(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static Integer quarter(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return QuarterProcessor.quarter(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static Integer weekOfYear(Object dateTime, String tzId) {
        if (dateTime == null || tzId == null) {
            return null;
        }
        return NonIsoDateTimeProcessor.NonIsoDateTimeExtractor.WEEK_OF_YEAR.extract(InternalSqlScriptUtils.asDateTime(dateTime), tzId);
    }

    public static ZonedDateTime dateAdd(String dateField, Integer numberOfUnits, Object dateTime, String tzId) {
        return (ZonedDateTime)DateAddProcessor.process(dateField, numberOfUnits, InternalSqlScriptUtils.asDateTime(dateTime), ZoneId.of(tzId));
    }

    public static Integer dateDiff(String dateField, Object dateTime1, Object dateTime2, String tzId) {
        return (Integer)DateDiffProcessor.process(dateField, InternalSqlScriptUtils.asDateTime(dateTime1), InternalSqlScriptUtils.asDateTime(dateTime2), ZoneId.of(tzId));
    }

    public static Object dateTrunc(String truncateTo, Object dateTimeOrInterval, String tzId) {
        if (dateTimeOrInterval instanceof IntervalDayTime || dateTimeOrInterval instanceof IntervalYearMonth) {
            return DateTruncProcessor.process(truncateTo, dateTimeOrInterval, ZoneId.of(tzId));
        }
        return DateTruncProcessor.process(truncateTo, InternalSqlScriptUtils.asDateTime(dateTimeOrInterval), ZoneId.of(tzId));
    }

    public static Object dateParse(String dateField, String pattern, String tzId) {
        return DateTimeParseProcessor.Parser.DATE.parse(dateField, pattern, ZoneId.of(tzId));
    }

    public static Integer datePart(String dateField, Object dateTime, String tzId) {
        return (Integer)DatePartProcessor.process(dateField, InternalSqlScriptUtils.asDateTime(dateTime), ZoneId.of(tzId));
    }

    public static String dateTimeFormat(Object dateTime, String pattern, String tzId) {
        return (String)DateTimeFormatProcessor.Formatter.DATE_TIME_FORMAT.format(InternalSqlScriptUtils.asDateTime(dateTime), pattern, ZoneId.of(tzId));
    }

    public static Object dateTimeParse(String dateField, String pattern, String tzId) {
        return DateTimeParseProcessor.Parser.DATE_TIME.parse(dateField, pattern, ZoneId.of(tzId));
    }

    public static String format(Object dateTime, String pattern, String tzId) {
        return (String)DateTimeFormatProcessor.Formatter.FORMAT.format(InternalSqlScriptUtils.asDateTime(dateTime), pattern, ZoneId.of(tzId));
    }

    public static Object timeParse(String dateField, String pattern, String tzId) {
        return DateTimeParseProcessor.Parser.TIME.parse(dateField, pattern, ZoneId.of(tzId));
    }

    public static ZonedDateTime asDateTime(Object dateTime) {
        return (ZonedDateTime)InternalSqlScriptUtils.asDateTime(dateTime, false);
    }

    private static Object asDateTime(Object dateTime, boolean lenient) {
        if (dateTime == null) {
            return null;
        }
        if (dateTime instanceof JodaCompatibleZonedDateTime) {
            return ((JodaCompatibleZonedDateTime)dateTime).getZonedDateTime();
        }
        if (dateTime instanceof ZonedDateTime) {
            return dateTime;
        }
        if (!lenient) {
            if (dateTime instanceof Number) {
                return DateUtils.asDateTime(((Number)dateTime).longValue());
            }
            if (dateTime instanceof String) {
                return DateUtils.asDateTime(dateTime.toString());
            }
            throw new SqlIllegalArgumentException("Invalid date encountered [{}]", dateTime);
        }
        return dateTime;
    }

    public static IntervalDayTime intervalDayTime(String text, String typeName) {
        if (text == null || typeName == null) {
            return null;
        }
        return new IntervalDayTime(Duration.parse(text), SqlDataTypes.fromSqlOrEsType(typeName));
    }

    public static IntervalYearMonth intervalYearMonth(String text, String typeName) {
        if (text == null || typeName == null) {
            return null;
        }
        return new IntervalYearMonth(Period.parse(text), SqlDataTypes.fromSqlOrEsType(typeName));
    }

    public static OffsetTime asTime(String time) {
        return OffsetTime.parse(time);
    }

    public static Integer ascii(String s) {
        return (Integer)StringProcessor.StringOperation.ASCII.apply(s);
    }

    public static Integer bitLength(String s) {
        return (Integer)StringProcessor.StringOperation.BIT_LENGTH.apply(s);
    }

    public static String character(Number n) {
        return (String)StringProcessor.StringOperation.CHAR.apply(n);
    }

    public static Integer charLength(String s) {
        return (Integer)StringProcessor.StringOperation.CHAR_LENGTH.apply(s);
    }

    public static String concat(String s1, String s2) {
        return (String)ConcatFunctionProcessor.process(s1, s2);
    }

    public static String insert(String s, Number start, Number length, String r) {
        return (String)InsertFunctionProcessor.doProcess(s, start, length, r);
    }

    public static String lcase(String s) {
        return (String)StringProcessor.StringOperation.LCASE.apply(s);
    }

    public static String left(String s, Number count) {
        return BinaryStringNumericProcessor.BinaryStringNumericOperation.LEFT.apply(s, count);
    }

    public static Integer length(String s) {
        return (Integer)StringProcessor.StringOperation.LENGTH.apply(s);
    }

    public static Integer locate(String s1, String s2) {
        return InternalSqlScriptUtils.locate(s1, s2, null);
    }

    public static Integer locate(String s1, String s2, Number pos) {
        return LocateFunctionProcessor.doProcess(s1, s2, pos);
    }

    public static String ltrim(String s) {
        return (String)StringProcessor.StringOperation.LTRIM.apply(s);
    }

    public static Integer octetLength(String s) {
        return (Integer)StringProcessor.StringOperation.OCTET_LENGTH.apply(s);
    }

    public static Integer position(String s1, String s2) {
        return (Integer)BinaryStringStringProcessor.BinaryStringStringOperation.POSITION.apply(s1, s2);
    }

    public static String repeat(String s, Number count) {
        return BinaryStringNumericProcessor.BinaryStringNumericOperation.REPEAT.apply(s, count);
    }

    public static String replace(String s1, String s2, String s3) {
        return (String)ReplaceFunctionProcessor.doProcess(s1, s2, s3);
    }

    public static String right(String s, Number count) {
        return BinaryStringNumericProcessor.BinaryStringNumericOperation.RIGHT.apply(s, count);
    }

    public static String rtrim(String s) {
        return (String)StringProcessor.StringOperation.RTRIM.apply(s);
    }

    public static String space(Number n) {
        return (String)StringProcessor.StringOperation.SPACE.apply(n);
    }

    public static String substring(String s, Number start, Number length) {
        return (String)SubstringFunctionProcessor.doProcess(s, start, length);
    }

    public static String trim(String s) {
        return (String)StringProcessor.StringOperation.TRIM.apply(s);
    }

    public static String ucase(String s) {
        return (String)StringProcessor.StringOperation.UCASE.apply(s);
    }

    public static String stAswkt(Object v) {
        return GeoProcessor.GeoOperation.ASWKT.apply(v).toString();
    }

    public static GeoShape stWktToSql(String wktString) {
        return StWkttosqlProcessor.apply(wktString);
    }

    public static Double stDistance(Object v1, Object v2) {
        return StDistanceProcessor.process(v1, v2);
    }

    public static String stGeometryType(Object g) {
        return (String)GeoProcessor.GeoOperation.GEOMETRY_TYPE.apply(g);
    }

    public static Double stX(Object g) {
        return (Double)GeoProcessor.GeoOperation.X.apply(g);
    }

    public static Double stY(Object g) {
        return (Double)GeoProcessor.GeoOperation.Y.apply(g);
    }

    public static Double stZ(Object g) {
        return (Double)GeoProcessor.GeoOperation.Z.apply(g);
    }

    public static <T> GeoShape geoDocValue(Map<String, ScriptDocValues<T>> doc, String fieldName) {
        Object obj = InternalSqlScriptUtils.docValue(doc, (String)fieldName);
        if (obj != null && obj instanceof GeoPoint) {
            return new GeoShape(((GeoPoint)obj).getLon(), ((GeoPoint)obj).getLat());
        }
        return null;
    }

    public static Object cast(Object value, String typeName) {
        return SqlDataTypeConverter.convert(InternalSqlScriptUtils.asDateTime(value, true), SqlDataTypes.fromSqlOrEsType(typeName));
    }
}

