/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ConcatFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ConcatFunctionProcessor;

public class Concat
extends BinaryScalarFunction {
    public Concat(Source source, Expression source1, Expression source2) {
        super(source, source1, source2);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isStringAndExact((Expression)this.left(), (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isStringAndExact((Expression)this.right(), (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
    }

    protected Pipe makePipe() {
        return new ConcatFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.left()), Expressions.pipe((Expression)this.right()));
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    public boolean foldable() {
        return this.left().foldable() && this.right().foldable();
    }

    public Object fold() {
        return ConcatFunctionProcessor.process(this.left().fold(), this.right().fold());
    }

    protected Concat replaceChildren(Expression newLeft, Expression newRight) {
        return new Concat(this.source(), newLeft, newRight);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Concat::new, (Object)this.left(), (Object)this.right());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }
}

