/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class ThreeArgsDateTimeFunction
extends ScalarFunction {
    private final ZoneId zoneId;

    public ThreeArgsDateTimeFunction(Source source, Expression first, Expression second, Expression third, ZoneId zoneId) {
        super(source, Arrays.asList(first, second, third));
        this.zoneId = zoneId;
    }

    public Expression first() {
        return (Expression)this.arguments().get(0);
    }

    public Expression second() {
        return (Expression)this.arguments().get(1);
    }

    public Expression third() {
        return (Expression)this.arguments().get(2);
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    protected abstract boolean resolveDateTimeField(String var1);

    protected abstract List<String> findSimilarDateTimeFields(String var1);

    protected abstract List<String> validDateTimeFieldValues();

    public final ThreeArgsDateTimeFunction replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    protected abstract ThreeArgsDateTimeFunction replaceChildren(Expression var1, Expression var2, Expression var3);

    protected Pipe makePipe() {
        return this.createPipe(Expressions.pipe((Expression)this.first()), Expressions.pipe((Expression)this.second()), Expressions.pipe((Expression)this.third()), this.zoneId);
    }

    protected abstract Pipe createPipe(Pipe var1, Pipe var2, Pipe var3, ZoneId var4);

    public boolean foldable() {
        return this.first().foldable() && this.second().foldable() && this.third().foldable();
    }

    public ScriptTemplate asScript() {
        ScriptTemplate firstScript = this.asScript(this.first());
        ScriptTemplate secondScript = this.asScript(this.second());
        ScriptTemplate thirdScript = this.asScript(this.third());
        return this.asScriptFrom(firstScript, secondScript, thirdScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate firstScript, ScriptTemplate secondScript, ScriptTemplate thirdScript) {
        return new ScriptTemplate(this.formatTemplate("{sql}." + this.scriptMethodName() + "(" + firstScript.template() + "," + secondScript.template() + "," + thirdScript.template() + ",{})"), ParamsBuilder.paramsBuilder().script(firstScript.params()).script(secondScript.params()).script(thirdScript.params()).variable((Object)this.zoneId.getId()).build(), this.dataType());
    }

    protected String scriptMethodName() {
        return ((Object)((Object)this)).getClass().getSimpleName().toLowerCase(Locale.ROOT);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.zoneId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThreeArgsDateTimeFunction that = (ThreeArgsDateTimeFunction)((Object)o);
        return this.zoneId.equals(that.zoneId);
    }
}

