/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;

public abstract class DateTimeFunction
extends BaseDateTimeFunction {
    private final DateTimeProcessor.DateTimeExtractor extractor;

    DateTimeFunction(Source source, Expression field, ZoneId zoneId, DateTimeProcessor.DateTimeExtractor extractor) {
        super(source, field, zoneId);
        this.extractor = extractor;
    }

    public static Integer dateTimeChrono(ZonedDateTime dateTime, String tzId, String chronoName) {
        ZonedDateTime zdt = dateTime.withZoneSameInstant(ZoneId.of(tzId));
        return DateTimeFunction.dateTimeChrono(zdt, ChronoField.valueOf(chronoName));
    }

    protected static Integer dateTimeChrono(Temporal dateTime, ChronoField field) {
        return dateTime.get(field);
    }

    public ScriptTemplate asScript() {
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        ScriptTemplate script = super.asScript();
        String template = this.formatTemplate("{sql}.dateTimeChrono(" + script.template() + ", {}, {})");
        params.script(script.params()).variable((Object)this.zoneId().getId()).variable((Object)this.extractor.chronoField().name());
        return new ScriptTemplate(template, params.build(), this.dataType());
    }

    protected Processor makeProcessor() {
        return new DateTimeProcessor(this.extractor, this.zoneId());
    }

    public DataType dataType() {
        return DataTypes.INTEGER;
    }

    public abstract String dateTimeFormat();

    protected DateTimeProcessor.DateTimeExtractor extractor() {
        return this.extractor;
    }
}

