/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.expression.SqlTypeResolutions;

abstract class BaseDateTimeFunction
extends UnaryScalarFunction {
    private final ZoneId zoneId;

    BaseDateTimeFunction(Source source, Expression field, ZoneId zoneId) {
        super(source, field);
        this.zoneId = zoneId;
    }

    protected final NodeInfo<BaseDateTimeFunction> info() {
        return NodeInfo.create((Node)this, this.ctorForInfo(), (Object)this.field(), (Object)this.zoneId());
    }

    protected abstract NodeInfo.NodeCtor2<Expression, ZoneId, BaseDateTimeFunction> ctorForInfo();

    protected Expression.TypeResolution resolveType() {
        return SqlTypeResolutions.isDate(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public boolean foldable() {
        return this.field().foldable();
    }

    public Object fold() {
        return this.makeProcessor().process(this.field().fold());
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.field(), this.zoneId());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        BaseDateTimeFunction other = (BaseDateTimeFunction)((Object)obj);
        return Objects.equals(other.field(), this.field()) && Objects.equals(other.zoneId(), this.zoneId());
    }
}

