/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.seqno.RetentionLeaseActions;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrRetentionLeases;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.core.ccr.action.UnfollowAction;

public class TransportUnfollowAction
extends TransportMasterNodeAction<UnfollowAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportUnfollowAction.class);
    private final Client client;

    @Inject
    public TransportUnfollowAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super("indices:admin/xpack/ccr/unfollow", transportService, clusterService, threadPool, actionFilters, UnfollowAction.Request::new, indexNameExpressionResolver);
        this.client = Objects.requireNonNull(client);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(final UnfollowAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("unfollow_action", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState current) {
                String followerIndex = request.getFollowerIndex();
                return TransportUnfollowAction.unfollow(followerIndex, current);
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                final IndexMetadata indexMetadata = oldState.metadata().index(request.getFollowerIndex());
                Map ccrCustomMetadata = indexMetadata.getCustomData("ccr");
                String remoteClusterName = (String)ccrCustomMetadata.get("remote_cluster_name");
                Client remoteClient = TransportUnfollowAction.this.client.getRemoteClusterClient(remoteClusterName);
                String leaderIndexName = (String)ccrCustomMetadata.get("leader_index_name");
                String leaderIndexUuid = (String)ccrCustomMetadata.get("leader_index_uuid");
                Index leaderIndex = new Index(leaderIndexName, leaderIndexUuid);
                final String retentionLeaseId = CcrRetentionLeases.retentionLeaseId(oldState.getClusterName().value(), indexMetadata.getIndex(), remoteClusterName, leaderIndex);
                int numberOfShards = (Integer)IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(indexMetadata.getSettings());
                GroupedActionListener groupListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<RetentionLeaseActions.Response>>(){

                    public void onResponse(Collection<RetentionLeaseActions.Response> responses) {
                        logger.trace("[{}] removed retention lease [{}] on all leader primary shards", (Object)indexMetadata.getIndex(), (Object)retentionLeaseId);
                        listener.onResponse((Object)new AcknowledgedResponse(true));
                    }

                    public void onFailure(Exception e) {
                        logger.warn((Message)new ParameterizedMessage("[{}] failure while removing retention lease [{}] on leader primary shards", (Object)indexMetadata.getIndex(), (Object)retentionLeaseId), (Throwable)e);
                        ElasticsearchException wrapper = new ElasticsearchException((Throwable)e);
                        wrapper.addMetadata("es.failed_to_remove_retention_leases", new String[]{retentionLeaseId});
                        listener.onFailure((Exception)wrapper);
                    }
                }, numberOfShards);
                for (int i = 0; i < numberOfShards; ++i) {
                    ShardId followerShardId = new ShardId(indexMetadata.getIndex(), i);
                    ShardId leaderShardId = new ShardId(leaderIndex, i);
                    this.removeRetentionLeaseForShard(followerShardId, leaderShardId, retentionLeaseId, remoteClient, (ActionListener<RetentionLeaseActions.Response>)ActionListener.wrap(arg_0 -> ((GroupedActionListener)groupListener).onResponse(arg_0), e -> this.handleException(followerShardId, retentionLeaseId, leaderShardId, (ActionListener<RetentionLeaseActions.Response>)groupListener, (Exception)e)));
                }
            }

            private void removeRetentionLeaseForShard(ShardId followerShardId, ShardId leaderShardId, String retentionLeaseId, Client remoteClient, ActionListener<RetentionLeaseActions.Response> listener2) {
                logger.trace("{} removing retention lease [{}] while unfollowing leader index", (Object)followerShardId, (Object)retentionLeaseId);
                ThreadContext threadContext = TransportUnfollowAction.this.threadPool.getThreadContext();
                try (ThreadContext.StoredContext ignore = TransportUnfollowAction.this.threadPool.getThreadContext().stashContext();){
                    threadContext.markAsSystemContext();
                    CcrRetentionLeases.asyncRemoveRetentionLease(leaderShardId, retentionLeaseId, remoteClient, listener2);
                }
            }

            private void handleException(ShardId followerShardId, String retentionLeaseId, ShardId leaderShardId, ActionListener<RetentionLeaseActions.Response> listener2, Exception e) {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                assert (!(cause instanceof ElasticsearchSecurityException)) : e;
                if (cause instanceof RetentionLeaseNotFoundException) {
                    logger.trace((Message)new ParameterizedMessage("{} retention lease [{}] not found on {} while unfollowing", new Object[]{followerShardId, retentionLeaseId, leaderShardId}), (Throwable)e);
                    listener2.onResponse((Object)new RetentionLeaseActions.Response());
                } else {
                    logger.warn((Message)new ParameterizedMessage("{} failed to remove retention lease [{}] on {} while unfollowing", new Object[]{followerShardId, retentionLeaseId, leaderShardId}), (Throwable)e);
                    listener2.onFailure(e);
                }
            }
        });
    }

    protected ClusterBlockException checkBlock(UnfollowAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    static ClusterState unfollow(String followerIndex, ClusterState current) {
        IndexMetadata followerIMD = current.metadata().index(followerIndex);
        if (followerIMD == null) {
            throw new IndexNotFoundException(followerIndex);
        }
        if (followerIMD.getCustomData("ccr") == null) {
            throw new IllegalArgumentException("index [" + followerIndex + "] is not a follower index");
        }
        if (followerIMD.getState() != IndexMetadata.State.CLOSE) {
            throw new IllegalArgumentException("cannot convert the follower index [" + followerIndex + "] to a non-follower, because it has not been closed");
        }
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)current.metadata().custom("persistent_tasks");
        if (persistentTasks != null) {
            for (PersistentTasksCustomMetadata.PersistentTask persistentTask : persistentTasks.tasks()) {
                ShardFollowTask shardFollowTask;
                if (!persistentTask.getTaskName().equals("xpack/ccr/shard_follow_task") || !(shardFollowTask = (ShardFollowTask)persistentTask.getParams()).getFollowShardId().getIndexName().equals(followerIndex)) continue;
                throw new IllegalArgumentException("cannot convert the follower index [" + followerIndex + "] to a non-follower, because it has not been paused");
            }
        }
        Settings.Builder builder = Settings.builder();
        builder.put(followerIMD.getSettings());
        builder.remove(CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey());
        IndexMetadata.Builder newIndexMetadata = IndexMetadata.builder((IndexMetadata)followerIMD);
        newIndexMetadata.settings(builder);
        newIndexMetadata.settingsVersion(followerIMD.getSettingsVersion() + 1L);
        newIndexMetadata.removeCustom("ccr");
        Metadata newMetadata = Metadata.builder((Metadata)current.metadata()).put(newIndexMetadata).build();
        return ClusterState.builder((ClusterState)current).metadata(newMetadata).build();
    }
}

