/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ccr.action.ImmutableFollowParameters;

public class ShardFollowTask
extends ImmutableFollowParameters
implements XPackPlugin.XPackPersistentTaskParams {
    public static final String NAME = "xpack/ccr/shard_follow_task";
    private static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
    private static final ParseField FOLLOW_SHARD_INDEX_FIELD = new ParseField("follow_shard_index", new String[0]);
    private static final ParseField FOLLOW_SHARD_INDEX_UUID_FIELD = new ParseField("follow_shard_index_uuid", new String[0]);
    private static final ParseField FOLLOW_SHARD_SHARDID_FIELD = new ParseField("follow_shard_shard", new String[0]);
    private static final ParseField LEADER_SHARD_INDEX_FIELD = new ParseField("leader_shard_index", new String[0]);
    private static final ParseField LEADER_SHARD_INDEX_UUID_FIELD = new ParseField("leader_shard_index_uuid", new String[0]);
    private static final ParseField LEADER_SHARD_SHARDID_FIELD = new ParseField("leader_shard_shard", new String[0]);
    private static final ParseField HEADERS = new ParseField("headers", new String[0]);
    private static final ConstructingObjectParser<ShardFollowTask, Void> PARSER = new ConstructingObjectParser("xpack/ccr/shard_follow_task", a -> new ShardFollowTask((String)a[0], new ShardId((String)a[1], (String)a[2], ((Integer)a[3]).intValue()), new ShardId((String)a[4], (String)a[5], ((Integer)a[6]).intValue()), (Integer)a[7], (Integer)a[8], (Integer)a[9], (Integer)a[10], (ByteSizeValue)a[11], (ByteSizeValue)a[12], (Integer)a[13], (ByteSizeValue)a[14], (TimeValue)a[15], (TimeValue)a[16], (Map)a[17]));
    private final String remoteCluster;
    private final ShardId followShardId;
    private final ShardId leaderShardId;
    private final Map<String, String> headers;

    ShardFollowTask(String remoteCluster, ShardId followShardId, ShardId leaderShardId, int maxReadRequestOperationCount, int maxWriteRequestOperationCount, int maxOutstandingReadRequests, int maxOutstandingWriteRequests, ByteSizeValue maxReadRequestSize, ByteSizeValue maxWriteRequestSize, int maxWriteBufferCount, ByteSizeValue maxWriteBufferSize, TimeValue maxRetryDelay, TimeValue readPollTimeout, Map<String, String> headers) {
        super(Integer.valueOf(maxReadRequestOperationCount), Integer.valueOf(maxWriteRequestOperationCount), Integer.valueOf(maxOutstandingReadRequests), Integer.valueOf(maxOutstandingWriteRequests), maxReadRequestSize, maxWriteRequestSize, Integer.valueOf(maxWriteBufferCount), maxWriteBufferSize, maxRetryDelay, readPollTimeout);
        this.remoteCluster = remoteCluster;
        this.followShardId = followShardId;
        this.leaderShardId = leaderShardId;
        this.headers = headers != null ? Collections.unmodifiableMap(headers) : Collections.emptyMap();
    }

    public static ShardFollowTask readFrom(StreamInput in) throws IOException {
        String remoteCluster = in.readString();
        ShardId followShardId = new ShardId(in);
        ShardId leaderShardId = new ShardId(in);
        return new ShardFollowTask(remoteCluster, followShardId, leaderShardId, in);
    }

    private ShardFollowTask(String remoteCluster, ShardId followShardId, ShardId leaderShardId, StreamInput in) throws IOException {
        super(in);
        this.remoteCluster = remoteCluster;
        this.followShardId = followShardId;
        this.leaderShardId = leaderShardId;
        this.headers = Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readString));
    }

    public String getRemoteCluster() {
        return this.remoteCluster;
    }

    public ShardId getFollowShardId() {
        return this.followShardId;
    }

    public ShardId getLeaderShardId() {
        return this.leaderShardId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.remoteCluster);
        this.followShardId.writeTo(out);
        this.leaderShardId.writeTo(out);
        super.writeTo(out);
        out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
    }

    public static ShardFollowTask fromXContent(XContentParser parser) {
        return (ShardFollowTask)((Object)PARSER.apply(parser, null));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
        builder.field(FOLLOW_SHARD_INDEX_FIELD.getPreferredName(), this.followShardId.getIndex().getName());
        builder.field(FOLLOW_SHARD_INDEX_UUID_FIELD.getPreferredName(), this.followShardId.getIndex().getUUID());
        builder.field(FOLLOW_SHARD_SHARDID_FIELD.getPreferredName(), this.followShardId.id());
        builder.field(LEADER_SHARD_INDEX_FIELD.getPreferredName(), this.leaderShardId.getIndex().getName());
        builder.field(LEADER_SHARD_INDEX_UUID_FIELD.getPreferredName(), this.leaderShardId.getIndex().getUUID());
        builder.field(LEADER_SHARD_SHARDID_FIELD.getPreferredName(), this.leaderShardId.id());
        this.toXContentFragment(builder);
        builder.field(HEADERS.getPreferredName(), this.headers);
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShardFollowTask that = (ShardFollowTask)((Object)o);
        return Objects.equals(this.remoteCluster, that.remoteCluster) && Objects.equals(this.followShardId, that.followShardId) && Objects.equals(this.leaderShardId, that.leaderShardId) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.remoteCluster, this.followShardId, this.leaderShardId, this.headers);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_5_0;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REMOTE_CLUSTER_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FOLLOW_SHARD_INDEX_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FOLLOW_SHARD_INDEX_UUID_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), FOLLOW_SHARD_SHARDID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_SHARD_INDEX_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_SHARD_INDEX_UUID_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), LEADER_SHARD_SHARDID_FIELD);
        ImmutableFollowParameters.initParser(PARSER);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), HEADERS);
    }
}

