/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.ScriptDocValues;

public abstract class VectorScriptDocValues
extends ScriptDocValues<BytesRef> {
    private final BinaryDocValues in;
    private BytesRef value;

    VectorScriptDocValues(BinaryDocValues in) {
        this.in = in;
    }

    public void setNextDocId(int docId) throws IOException {
        this.value = this.in.advanceExact(docId) ? this.in.binaryValue() : null;
    }

    BytesRef getEncodedValue() {
        return this.value;
    }

    public BytesRef get(int index) {
        throw new UnsupportedOperationException("accessing a vector field's value through 'get' or 'value' is not supported");
    }

    public int size() {
        if (this.value == null) {
            return 0;
        }
        return 1;
    }

    public static class SparseVectorScriptDocValues
    extends VectorScriptDocValues {
        public SparseVectorScriptDocValues(BinaryDocValues in) {
            super(in);
        }
    }

    public static class DenseVectorScriptDocValues
    extends VectorScriptDocValues {
        public DenseVectorScriptDocValues(BinaryDocValues in) {
            super(in);
        }
    }
}

