/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.mapper;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xpack.vectors.query.VectorIndexFieldData;

public class DenseVectorFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "dense_vector";
    public static short MAX_DIMS_COUNT = (short)2048;
    private static final byte INT_BYTES = 4;
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated()));
    private final Version indexCreatedVersion;
    private final int dims;

    private static DenseVectorFieldMapper toType(FieldMapper in) {
        return (DenseVectorFieldMapper)in;
    }

    private DenseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, int dims, Version indexCreatedVersion, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        assert (this.fieldType.indexOptions() == IndexOptions.NONE);
        this.indexCreatedVersion = indexCreatedVersion;
        this.dims = dims;
    }

    protected DenseVectorFieldMapper clone() {
        return (DenseVectorFieldMapper)super.clone();
    }

    public DenseVectorFieldType fieldType() {
        return (DenseVectorFieldType)super.fieldType();
    }

    public boolean parsesArrayValue() {
        return true;
    }

    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] can't be used in multi-fields");
        }
        int dims = this.fieldType().dims();
        byte[] bytes = this.indexCreatedVersion.onOrAfter(Version.V_7_5_0) ? new byte[dims * 4 + 4] : new byte[dims * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        double dotProduct = 0.0;
        int dim = 0;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_ARRAY) {
            if (dim++ >= dims) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] of doc [" + context.sourceToParse().id() + "] has exceeded the number of dimensions [" + dims + "] defined in mapping");
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)context.parser());
            float value = context.parser().floatValue(true);
            byteBuffer.putFloat(value);
            dotProduct += (double)(value * value);
            token = context.parser().nextToken();
        }
        if (dim != dims) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] of doc [" + context.sourceToParse().id() + "] has number of dimensions [" + dim + "] less than defined in the mapping [" + dims + "]");
        }
        if (this.indexCreatedVersion.onOrAfter(Version.V_7_5_0)) {
            float vectorMagnitude = (float)Math.sqrt(dotProduct);
            byteBuffer.putFloat(vectorMagnitude);
        }
        BinaryDocValuesField field = new BinaryDocValuesField(this.fieldType().name(), new BytesRef(bytes));
        if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't not support indexing multiple values for the same field in the same document");
        }
        context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)field);
    }

    protected boolean indexedByDefault() {
        return false;
    }

    protected boolean docValuesByDefault() {
        return true;
    }

    protected void parseCreateField(ParseContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion).init((FieldMapper)this);
    }

    public static final class DenseVectorFieldType
    extends MappedFieldType {
        private final int dims;

        public DenseVectorFieldType(String name, int dims, Map<String, String> meta) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
            this.dims = dims;
        }

        int dims() {
            return this.dims;
        }

        public String typeName() {
            return DenseVectorFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this.name(), mapperService){

                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        public boolean isAggregatable() {
            return false;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new VectorIndexFieldData.Builder(this.name(), true, (ValuesSourceType)CoreValuesSourceType.BYTES);
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support queries");
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        ParametrizedFieldMapper.Parameter<Integer> dims = new ParametrizedFieldMapper.Parameter("dims", false, () -> null, (n, c, o) -> XContentMapValues.nodeIntegerValue((Object)o), m -> DenseVectorFieldMapper.access$200(DenseVectorFieldMapper.toType(m))).setValidator(dims -> {
            if (dims == null) {
                throw new MapperParsingException("Missing required parameter [dims] for field [" + this.name + "]");
            }
            if (dims > MAX_DIMS_COUNT || dims < 1) {
                throw new MapperParsingException("The number of dimensions for field [" + this.name + "] should be in the range [1, " + MAX_DIMS_COUNT + "] but was [" + dims + "]");
            }
        });
        ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        final Version indexVersionCreated;

        public Builder(String name, Version indexVersionCreated) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.dims, this.meta);
        }

        public DenseVectorFieldMapper build(Mapper.BuilderContext context) {
            return new DenseVectorFieldMapper(this.name, new DenseVectorFieldType(this.buildFullName(context), (Integer)this.dims.getValue(), (Map)this.meta.getValue()), (Integer)this.dims.getValue(), this.indexVersionCreated, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build());
        }
    }
}

