/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestCloseJobAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.singletonList(new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/_close", RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/_close"));
    }

    public String getName() {
        return "ml_close_job_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        CloseJobAction.Request request;
        if (restRequest.hasContentOrSourceParam()) {
            request = CloseJobAction.Request.parseRequest((String)restRequest.param(Job.ID.getPreferredName()), (XContentParser)restRequest.contentParser());
        } else {
            request = new CloseJobAction.Request(restRequest.param(Job.ID.getPreferredName()));
            if (restRequest.hasParam(CloseJobAction.Request.TIMEOUT.getPreferredName())) {
                request.setCloseTimeout(TimeValue.parseTimeValue((String)restRequest.param(CloseJobAction.Request.TIMEOUT.getPreferredName()), (String)CloseJobAction.Request.TIMEOUT.getPreferredName()));
            }
            if (restRequest.hasParam(CloseJobAction.Request.FORCE.getPreferredName())) {
                request.setForce(restRequest.paramAsBoolean(CloseJobAction.Request.FORCE.getPreferredName(), request.isForce()));
            }
            if (restRequest.hasParam("allow_no_jobs")) {
                LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(null, () -> null, "allow_no_jobs", CloseJobAction.Request.ALLOW_NO_MATCH.getPreferredName());
            }
            request.setAllowNoMatch(restRequest.paramAsBoolean(CloseJobAction.Request.ALLOW_NO_MATCH.getPreferredName(), restRequest.paramAsBoolean("allow_no_jobs", request.allowNoMatch())));
        }
        return channel -> client.execute((ActionType)CloseJobAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

