/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

public class RestPutTrainedModelAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.singletonList(new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID.getPreferredName() + "}", RestRequest.Method.PUT, "/_ml/inference/{" + TrainedModelConfig.MODEL_ID.getPreferredName() + "}"));
    }

    public String getName() {
        return "xpack_ml_put_trained_model_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String id = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        XContentParser parser = restRequest.contentParser();
        PutTrainedModelAction.Request putRequest = PutTrainedModelAction.Request.parseRequest((String)id, (XContentParser)parser);
        putRequest.timeout(restRequest.paramAsTime("timeout", putRequest.timeout()));
        return channel -> client.execute((ActionType)PutTrainedModelAction.INSTANCE, (ActionRequest)putRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

