/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.dataframe;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;

public class RestStartDataFrameAnalyticsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_ml/data_frame/analytics/{" + DataFrameAnalyticsConfig.ID.getPreferredName() + "}/_start"));
    }

    public String getName() {
        return "xpack_ml_start_data_frame_analytics_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        StartDataFrameAnalyticsAction.Request request;
        String id = restRequest.param(DataFrameAnalyticsConfig.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            request = StartDataFrameAnalyticsAction.Request.parseRequest((String)id, (XContentParser)restRequest.contentOrSourceParamParser());
        } else {
            request = new StartDataFrameAnalyticsAction.Request(id);
            if (restRequest.hasParam(StartDataFrameAnalyticsAction.Request.TIMEOUT.getPreferredName())) {
                TimeValue timeout = restRequest.paramAsTime(StartDataFrameAnalyticsAction.Request.TIMEOUT.getPreferredName(), request.getTimeout());
                request.setTimeout(timeout);
            }
        }
        return channel -> client.execute((ActionType)StartDataFrameAnalyticsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

