/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process.writer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.xpack.ml.process.writer.LengthEncodedWriter;

public abstract class AbstractControlMsgWriter {
    public static final int FLUSH_SPACES_LENGTH = 8192;
    protected final LengthEncodedWriter lengthEncodedWriter;
    private final int numberOfFields;

    public AbstractControlMsgWriter(LengthEncodedWriter lengthEncodedWriter, int numberOfFields) {
        this.lengthEncodedWriter = Objects.requireNonNull(lengthEncodedWriter);
        this.numberOfFields = numberOfFields;
    }

    protected void fillCommandBuffer() throws IOException {
        char[] spaces = new char[8192];
        Arrays.fill(spaces, ' ');
        this.writeMessage(new String(spaces));
    }

    protected void writeMessage(String message) throws IOException {
        this.lengthEncodedWriter.writeNumFields(this.numberOfFields);
        for (int i = 1; i < this.numberOfFields; ++i) {
            this.lengthEncodedWriter.writeField("");
        }
        this.lengthEncodedWriter.writeField(message);
    }
}

