/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.annotations.Annotation;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class JobDataDeleter {
    private static final Logger LOGGER = LogManager.getLogger(JobDataDeleter.class);
    private final Client client;
    private final String jobId;

    public JobDataDeleter(Client client, String jobId) {
        this.client = Objects.requireNonNull(client);
        this.jobId = Objects.requireNonNull(jobId);
    }

    public void deleteModelSnapshots(List<ModelSnapshot> modelSnapshots, ActionListener<BulkByScrollResponse> listener) {
        if (modelSnapshots.isEmpty()) {
            listener.onResponse((Object)new BulkByScrollResponse(TimeValue.ZERO, new BulkByScrollTask.Status(Collections.emptyList(), null), Collections.emptyList(), Collections.emptyList(), false));
            return;
        }
        String stateIndexName = AnomalyDetectorsIndex.jobStateIndexPattern();
        ArrayList<String> idsToDelete = new ArrayList<String>();
        HashSet<String> indices = new HashSet<String>();
        indices.add(stateIndexName);
        indices.add(".ml-annotations-read");
        for (ModelSnapshot modelSnapshot : modelSnapshots) {
            idsToDelete.addAll(modelSnapshot.stateDocumentIds());
            idsToDelete.add(ModelSnapshot.documentId((ModelSnapshot)modelSnapshot));
            idsToDelete.add(ModelSnapshot.annotationDocumentId((ModelSnapshot)modelSnapshot));
            indices.add(AnomalyDetectorsIndex.jobResultsAliasedName((String)modelSnapshot.getJobId()));
        }
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)new DeleteByQueryRequest(indices.toArray(new String[0])).setRefresh(true)).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(idsToDelete.toArray(new String[0])));
        deleteByQueryRequest.getSearchRequest().source().sort("_doc");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, listener);
    }

    public void deleteAllAnnotations(ActionListener<Boolean> listener) {
        this.deleteAnnotationsFromTime(null, null, listener);
    }

    public void deleteAnnotationsFromTime(@Nullable Long cutoffEpochMs, @Nullable Set<String> eventsToDelete, ActionListener<Boolean> listener) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)this.jobId)).filter((QueryBuilder)QueryBuilders.termQuery((String)Annotation.CREATE_USERNAME.getPreferredName(), (String)"_xpack"));
        if (cutoffEpochMs != null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).gte((Object)cutoffEpochMs));
        }
        if (eventsToDelete != null && !eventsToDelete.isEmpty()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)Annotation.EVENT.getPreferredName(), eventsToDelete));
        }
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)boolQuery);
        DeleteByQueryRequest dbqRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{".ml-annotations-read"}).setQuery((QueryBuilder)query).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setAbortOnVersionConflict(false)).setRefresh(true)).setSlices(0);
        dbqRequest.getSearchRequest().source().sort("_doc");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)dbqRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)true), arg_0 -> listener.onFailure(arg_0)));
    }

    public void deleteResultsFromTime(long cutoffEpochMs, ActionListener<Boolean> listener) {
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)Result.RESULT_TYPE.getPreferredName())).filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).gte((Object)cutoffEpochMs));
        DeleteByQueryRequest dbqRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId)}).setQuery((QueryBuilder)query).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setAbortOnVersionConflict(false)).setRefresh(true)).setSlices(0);
        dbqRequest.getSearchRequest().source().sort("_doc");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)dbqRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)true), arg_0 -> listener.onFailure(arg_0)));
    }

    public void deleteInterimResults() {
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)Result.IS_INTERIM.getPreferredName(), (boolean)true));
        DeleteByQueryRequest dbqRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId)}).setQuery((QueryBuilder)query).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setAbortOnVersionConflict(false)).setRefresh(false)).setSlices(0);
        dbqRequest.getSearchRequest().source().sort("_doc");
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)dbqRequest).get();
        }
        catch (Exception e) {
            LOGGER.error("[" + this.jobId + "] An error occurred while deleting interim results", (Throwable)e);
        }
    }

    public void deleteDatafeedTimingStats(ActionListener<BulkByScrollResponse> listener) {
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId)}).setRefresh(true)).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{DatafeedTimingStats.documentId((String)this.jobId)}));
        deleteByQueryRequest.getSearchRequest().source().sort("_doc");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, listener);
    }
}

