/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.aggs;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;

public class InternalInferenceAggregation
extends InternalAggregation {
    private final InferenceResults inferenceResult;

    protected InternalInferenceAggregation(String name, Map<String, Object> metadata, InferenceResults inferenceResult) {
        super(name, metadata);
        this.inferenceResult = inferenceResult;
    }

    public InternalInferenceAggregation(StreamInput in) throws IOException {
        super(in);
        this.inferenceResult = (InferenceResults)in.readNamedWriteable(InferenceResults.class);
    }

    public InferenceResults getInferenceResult() {
        return this.inferenceResult;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.inferenceResult);
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("Reducing an inference aggregation is not supported");
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getProperty(List<String> path) {
        void var2_4;
        if (path.isEmpty()) {
            InternalInferenceAggregation internalInferenceAggregation = this;
            return var2_4;
        } else {
            if (path.size() != 1) throw this.invalidPathException(path);
            if (!Aggregation.CommonFields.VALUE.getPreferredName().equals(path.get(0))) throw this.invalidPathException(path);
            Object object = this.inferenceResult.predictedValue();
        }
        return var2_4;
    }

    private InvalidAggregationPathException invalidPathException(List<String> path) {
        return new InvalidAggregationPathException("unknown property " + path + " for " + "inference" + " aggregation [" + this.getName() + "]");
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.inferenceResult.toXContent(builder, params);
    }

    public String getWriteableName() {
        return "inference";
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inferenceResult);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalInferenceAggregation other = (InternalInferenceAggregation)((Object)obj);
        return Objects.equals(this.inferenceResult, other.inferenceResult);
    }
}

