/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.util.List;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FileStructure;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinderFactory;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;
import org.elasticsearch.xpack.ml.filestructurefinder.TextLogFileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;

public class TextLogFileStructureFinderFactory
implements FileStructureFinderFactory {
    private static final Pattern TWO_NON_BLANK_LINES_PATTERN = Pattern.compile(".\n+.");

    @Override
    public boolean canFindFormat(FileStructure.Format format) {
        return format == null || format == FileStructure.Format.SEMI_STRUCTURED_TEXT;
    }

    @Override
    public boolean canCreateFromSample(List<String> explanation, String sample, double allowedFractionOfBadLines) {
        if (sample.indexOf(10) < 0) {
            explanation.add("Not text because sample contains no newlines");
            return false;
        }
        if (!TWO_NON_BLANK_LINES_PATTERN.matcher(sample).find()) {
            explanation.add("Not text because sample contains fewer than two non-blank lines");
            return false;
        }
        explanation.add("Deciding sample is text");
        return true;
    }

    @Override
    public FileStructureFinder createFromSample(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, int lineMergeSizeLimit, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        return TextLogFileStructureFinder.makeTextLogFileStructureFinder(explanation, sample, charsetName, hasByteOrderMarker, lineMergeSizeLimit, overrides, timeoutChecker);
    }
}

