/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.extractor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.ml.extractor.DocValueField;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.GeoPointField;
import org.elasticsearch.xpack.ml.extractor.GeoShapeField;
import org.elasticsearch.xpack.ml.extractor.MultiField;
import org.elasticsearch.xpack.ml.extractor.ProcessedField;
import org.elasticsearch.xpack.ml.extractor.ScriptField;
import org.elasticsearch.xpack.ml.extractor.SourceField;
import org.elasticsearch.xpack.ml.extractor.TimeField;

public class ExtractedFields {
    private final List<ExtractedField> allFields;
    private final List<ExtractedField> docValueFields;
    private final List<ProcessedField> processedFields;
    private final String[] sourceFields;
    private final Map<String, Long> cardinalitiesForFieldsWithConstraints;

    public ExtractedFields(List<ExtractedField> allFields, List<ProcessedField> processedFields, Map<String, Long> cardinalitiesForFieldsWithConstraints) {
        this.allFields = new ArrayList<ExtractedField>(allFields);
        this.docValueFields = ExtractedFields.filterFields(ExtractedField.Method.DOC_VALUE, allFields);
        this.sourceFields = (String[])ExtractedFields.filterFields(ExtractedField.Method.SOURCE, allFields).stream().map(ExtractedField::getSearchField).toArray(String[]::new);
        this.cardinalitiesForFieldsWithConstraints = Collections.unmodifiableMap(cardinalitiesForFieldsWithConstraints);
        this.processedFields = processedFields == null ? Collections.emptyList() : processedFields;
    }

    public List<ProcessedField> getProcessedFields() {
        return this.processedFields;
    }

    public List<ExtractedField> getAllFields() {
        return this.allFields;
    }

    public Set<String> getProcessedFieldInputs() {
        return this.processedFields.stream().map(ProcessedField::getInputFieldNames).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String[] getSourceFields() {
        return this.sourceFields;
    }

    public List<ExtractedField> getDocValueFields() {
        return this.docValueFields;
    }

    public Map<String, Long> getCardinalitiesForFieldsWithConstraints() {
        return this.cardinalitiesForFieldsWithConstraints;
    }

    public String[] extractOrganicFeatureNames() {
        Set<String> processedFieldInputs = this.getProcessedFieldInputs();
        return (String[])this.allFields.stream().map(ExtractedField::getName).filter(f -> !processedFieldInputs.contains(f)).toArray(String[]::new);
    }

    public String[] extractProcessedFeatureNames() {
        return (String[])this.processedFields.stream().map(ProcessedField::getOutputFieldNames).flatMap(Collection::stream).toArray(String[]::new);
    }

    private static List<ExtractedField> filterFields(ExtractedField.Method method, List<ExtractedField> fields) {
        return fields.stream().filter(field -> field.getMethod() == method).collect(Collectors.toList());
    }

    public static ExtractedFields build(Set<String> allFields, Set<String> scriptFields, FieldCapabilitiesResponse fieldsCapabilities, Map<String, Long> cardinalitiesForFieldsWithConstraints, List<ProcessedField> processedFields) {
        ExtractionMethodDetector extractionMethodDetector = new ExtractionMethodDetector(scriptFields, fieldsCapabilities);
        return new ExtractedFields(allFields.stream().map(extractionMethodDetector::detect).collect(Collectors.toList()), processedFields, cardinalitiesForFieldsWithConstraints);
    }

    public static TimeField newTimeField(String name, ExtractedField.Method method) {
        return new TimeField(name, method);
    }

    public static ExtractedField applyBooleanMapping(ExtractedField field) {
        return new BooleanMapper<Integer>(field, 1, 0);
    }

    private static final class BooleanMapper<T>
    extends DocValueField {
        private static final Set<String> TYPES = Collections.singleton("boolean");
        private final T trueValue;
        private final T falseValue;

        BooleanMapper(ExtractedField field, T trueValue, T falseValue) {
            super(field.getName(), TYPES);
            if (field.getMethod() != ExtractedField.Method.DOC_VALUE || !field.getTypes().contains("boolean")) {
                throw new IllegalArgumentException("cannot apply boolean mapping to field [" + field.getName() + "]");
            }
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public Object[] value(SearchHit hit) {
            DocumentField keyValue = hit.field(this.getName());
            if (keyValue != null) {
                return keyValue.getValues().stream().map(v -> Boolean.TRUE.equals(v) ? this.trueValue : this.falseValue).toArray();
            }
            return new Object[0];
        }

        @Override
        public boolean supportsFromSource() {
            return false;
        }

        @Override
        public ExtractedField newFromSource() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ExtractionMethodDetector {
        private final Set<String> scriptFields;
        private final FieldCapabilitiesResponse fieldsCapabilities;

        public ExtractionMethodDetector(Set<String> scriptFields, FieldCapabilitiesResponse fieldsCapabilities) {
            this.scriptFields = scriptFields;
            this.fieldsCapabilities = fieldsCapabilities;
        }

        public ExtractedField detect(String field) {
            if (this.scriptFields.contains(field)) {
                return new ScriptField(field);
            }
            ExtractedField extractedField = this.detectNonScriptField(field);
            String parentField = MlStrings.getParentField((String)field);
            if (this.isMultiField(field, parentField)) {
                if (this.isAggregatable(field)) {
                    return new MultiField(parentField, extractedField);
                }
                ExtractedField parentExtractionField = this.detectNonScriptField(parentField);
                return new MultiField(field, parentField, parentField, parentExtractionField);
            }
            return extractedField;
        }

        private ExtractedField detectNonScriptField(String field) {
            if (this.isFieldOfTypes(field, TimeField.TYPES) && this.isAggregatable(field)) {
                return new TimeField(field, ExtractedField.Method.DOC_VALUE);
            }
            if (this.isFieldOfType(field, "geo_point")) {
                if (!this.isAggregatable(field)) {
                    throw new IllegalArgumentException("cannot use [geo_point] field with disabled doc values");
                }
                return new GeoPointField(field);
            }
            if (this.isFieldOfType(field, "geo_shape")) {
                return new GeoShapeField(field);
            }
            Set<String> types = this.getTypes(field);
            return this.isAggregatable(field) ? new DocValueField(field, types) : new SourceField(field, types);
        }

        private Set<String> getTypes(String field) {
            Map fieldCaps = this.fieldsCapabilities.getField(field);
            return fieldCaps == null ? Collections.emptySet() : fieldCaps.keySet();
        }

        public boolean isAggregatable(String field) {
            Map fieldCaps = this.fieldsCapabilities.getField(field);
            if (fieldCaps == null || fieldCaps.isEmpty()) {
                throw new IllegalArgumentException("cannot retrieve field [" + field + "] because it has no mappings");
            }
            for (FieldCapabilities capsPerIndex : fieldCaps.values()) {
                if (capsPerIndex.isAggregatable()) continue;
                return false;
            }
            return true;
        }

        private boolean isFieldOfType(String field, String type) {
            return this.isFieldOfTypes(field, Collections.singleton(type));
        }

        private boolean isFieldOfTypes(String field, Set<String> types) {
            assert (!types.isEmpty());
            Map fieldCaps = this.fieldsCapabilities.getField(field);
            if (fieldCaps != null && !fieldCaps.isEmpty()) {
                return types.containsAll(fieldCaps.keySet());
            }
            return false;
        }

        private boolean isMultiField(String field, String parent) {
            if (Objects.equals(field, parent)) {
                return false;
            }
            Map parentFieldCaps = this.fieldsCapabilities.getField(parent);
            return parentFieldCaps != null && (parentFieldCaps.size() != 1 || !parentFieldCaps.containsKey("object"));
        }
    }
}

