/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class StatsPersister {
    private static final Logger LOGGER = LogManager.getLogger(StatsPersister.class);
    private final String jobId;
    private final ResultsPersisterService resultsPersisterService;
    private final DataFrameAnalyticsAuditor auditor;

    public StatsPersister(String jobId, ResultsPersisterService resultsPersisterService, DataFrameAnalyticsAuditor auditor) {
        this.jobId = Objects.requireNonNull(jobId);
        this.resultsPersisterService = Objects.requireNonNull(resultsPersisterService);
        this.auditor = Objects.requireNonNull(auditor);
    }

    public void persistWithRetry(ToXContentObject result, Function<String, String> docIdSupplier) {
        try {
            this.resultsPersisterService.indexWithRetry(this.jobId, MlStatsIndex.writeAlias(), (ToXContent)result, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true")), WriteRequest.RefreshPolicy.NONE, docIdSupplier.apply(this.jobId), true, () -> true, errorMsg -> this.auditor.error(this.jobId, "failed to persist result with id [" + (String)docIdSupplier.apply(this.jobId) + "]; " + errorMsg));
        }
        catch (IOException ioe) {
            LOGGER.error(() -> new ParameterizedMessage("[{}] Failed serializing stats result", (Object)this.jobId), (Throwable)ioe);
        }
        catch (Exception e) {
            LOGGER.error(() -> new ParameterizedMessage("[{}] Failed indexing stats result", (Object)this.jobId), (Throwable)e);
        }
    }
}

