/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process.results;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelDefinitionDoc;

public class TrainedModelDefinitionChunk
implements ToXContentObject {
    private static final ParseField DEFINITION = new ParseField("definition", new String[0]);
    private static final ParseField DOC_NUM = new ParseField("doc_num", new String[0]);
    private static final ParseField EOS = new ParseField("eos", new String[0]);
    public static final ConstructingObjectParser<TrainedModelDefinitionChunk, Void> PARSER = new ConstructingObjectParser("chunked_trained_model_definition", a -> new TrainedModelDefinitionChunk((String)a[0], (Integer)a[1], (Boolean)a[2]));
    private final String definition;
    private final int docNum;
    private final Boolean eos;

    public TrainedModelDefinitionChunk(String definition, int docNum, Boolean eos) {
        this.definition = definition;
        this.docNum = docNum;
        this.eos = eos;
    }

    public TrainedModelDefinitionDoc createTrainedModelDoc(String modelId) {
        return new TrainedModelDefinitionDoc.Builder().setCompressionVersion(1).setModelId(modelId).setDefinitionLength(this.definition.length()).setDocNum(this.docNum).setCompressedString(this.definition).setEos(this.isEos()).build();
    }

    public boolean isEos() {
        return this.eos != null && this.eos != false;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DEFINITION.getPreferredName(), this.definition);
        builder.field(DOC_NUM.getPreferredName(), this.docNum);
        if (this.eos != null) {
            builder.field(EOS.getPreferredName(), this.eos);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelDefinitionChunk that = (TrainedModelDefinitionChunk)o;
        return this.docNum == that.docNum && Objects.equals(this.definition, that.definition) && Objects.equals(this.eos, that.eos);
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.docNum, this.eos);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DEFINITION);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), DOC_NUM);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), EOS);
    }
}

