/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.annotations;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.ml.annotations.Annotation;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class AnnotationPersister {
    private static final Logger logger = LogManager.getLogger(AnnotationPersister.class);
    private static final int DEFAULT_BULK_LIMIT = 10000;
    private final ResultsPersisterService resultsPersisterService;
    private final AbstractAuditor<?> auditor;
    private final int bulkLimit;

    public AnnotationPersister(ResultsPersisterService resultsPersisterService, AbstractAuditor<?> auditor) {
        this(resultsPersisterService, auditor, 10000);
    }

    AnnotationPersister(ResultsPersisterService resultsPersisterService, AbstractAuditor<?> auditor, int bulkLimit) {
        this.resultsPersisterService = Objects.requireNonNull(resultsPersisterService);
        this.auditor = Objects.requireNonNull(auditor);
        this.bulkLimit = bulkLimit;
    }

    public Tuple<String, Annotation> persistAnnotation(@Nullable String annotationId, Annotation annotation) {
        Objects.requireNonNull(annotation);
        String jobId = annotation.getJobId();
        BulkResponse bulkResponse = this.bulkPersisterBuilder(jobId).persistAnnotation(annotationId, annotation).executeRequest();
        assert (bulkResponse.getItems().length == 1);
        return Tuple.tuple((Object)bulkResponse.getItems()[0].getId(), (Object)annotation);
    }

    public Builder bulkPersisterBuilder(String jobId) {
        return new Builder(jobId);
    }

    public class Builder {
        private final String jobId;
        private BulkRequest bulkRequest = new BulkRequest(".ml-annotations-write");
        private java.util.function.Supplier<Boolean> shouldRetry = () -> true;

        private Builder(String jobId) {
            this.jobId = Objects.requireNonNull(jobId);
        }

        public Builder shouldRetry(java.util.function.Supplier<Boolean> shouldRetry) {
            this.shouldRetry = Objects.requireNonNull(shouldRetry);
            return this;
        }

        public Builder persistAnnotation(Annotation annotation) {
            return this.persistAnnotation(null, annotation);
        }

        public Builder persistAnnotation(@Nullable String annotationId, Annotation annotation) {
            Objects.requireNonNull(annotation);
            try (XContentBuilder xContentBuilder = annotation.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);){
                this.bulkRequest.add(new IndexRequest().id(annotationId).source(xContentBuilder).setRequireAlias(true));
            }
            catch (IOException e) {
                logger.error((Message)new ParameterizedMessage("[{}] Error serialising annotation", (Object)this.jobId), (Throwable)e);
            }
            if (this.bulkRequest.numberOfActions() >= AnnotationPersister.this.bulkLimit) {
                this.executeRequest();
            }
            return this;
        }

        public BulkResponse executeRequest() {
            if (this.bulkRequest.numberOfActions() == 0) {
                return null;
            }
            logger.trace("[{}] ES API CALL: bulk request with {} actions", new Supplier[]{() -> this.jobId, () -> this.bulkRequest.numberOfActions()});
            BulkResponse bulkResponse = AnnotationPersister.this.resultsPersisterService.bulkIndexWithRetry(this.bulkRequest, this.jobId, this.shouldRetry, msg -> AnnotationPersister.this.auditor.warning(this.jobId, "Bulk indexing of annotations failed " + msg));
            this.bulkRequest = new BulkRequest(".ml-annotations-write");
            return bulkResponse;
        }
    }
}

