/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.UpdateModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportUpdateModelSnapshotAction
extends HandledTransportAction<UpdateModelSnapshotAction.Request, UpdateModelSnapshotAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateModelSnapshotAction.class);
    private final JobResultsProvider jobResultsProvider;
    private final Client client;

    @Inject
    public TransportUpdateModelSnapshotAction(TransportService transportService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider, Client client) {
        super("cluster:admin/xpack/ml/job/model_snapshots/update", transportService, actionFilters, UpdateModelSnapshotAction.Request::new);
        this.jobResultsProvider = jobResultsProvider;
        this.client = client;
    }

    protected void doExecute(Task task, UpdateModelSnapshotAction.Request request, ActionListener<UpdateModelSnapshotAction.Response> listener) {
        logger.debug("Received request to update model snapshot [{}] for job [{}]", (Object)request.getSnapshotId(), (Object)request.getJobId());
        this.jobResultsProvider.getModelSnapshot(request.getJobId(), request.getSnapshotId(), modelSnapshot -> {
            if (modelSnapshot == null) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"No model snapshot with id [{0}] exists for job [{1}]", (Object[])new Object[]{request.getSnapshotId(), request.getJobId()}), new Object[0])));
            } else {
                Result<ModelSnapshot> updatedSnapshot = TransportUpdateModelSnapshotAction.applyUpdate(request, (Result<ModelSnapshot>)modelSnapshot);
                this.indexModelSnapshot(updatedSnapshot, b -> listener.onResponse((Object)new UpdateModelSnapshotAction.Response(new ModelSnapshot.Builder((ModelSnapshot)updatedSnapshot.result).setQuantiles(null).build())), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private static Result<ModelSnapshot> applyUpdate(UpdateModelSnapshotAction.Request request, Result<ModelSnapshot> target) {
        ModelSnapshot.Builder updatedSnapshotBuilder = new ModelSnapshot.Builder((ModelSnapshot)target.result);
        if (request.getDescription() != null) {
            updatedSnapshotBuilder.setDescription(request.getDescription());
        }
        if (request.getRetain() != null) {
            updatedSnapshotBuilder.setRetain(request.getRetain().booleanValue());
        }
        return new Result(target.index, (Object)updatedSnapshotBuilder.build());
    }

    private void indexModelSnapshot(Result<ModelSnapshot> modelSnapshot, final Consumer<Boolean> handler, final Consumer<Exception> errorHandler) {
        IndexRequest indexRequest = new IndexRequest(modelSnapshot.index).id(ModelSnapshot.documentId((ModelSnapshot)((ModelSnapshot)modelSnapshot.result)));
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            ((ModelSnapshot)modelSnapshot.result).toXContent(builder, ToXContent.EMPTY_PARAMS);
            indexRequest.source(builder);
        }
        catch (IOException e) {
            errorHandler.accept(e);
            return;
        }
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        bulkRequestBuilder.add(indexRequest);
        bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)BulkAction.INSTANCE, (ActionRequest)((BulkRequest)bulkRequestBuilder.request()), (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse indexResponse) {
                handler.accept(true);
            }

            public void onFailure(Exception e) {
                errorHandler.accept(e);
            }
        });
    }
}

