/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.annotations.Annotation;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportRevertModelSnapshotAction
extends TransportMasterNodeAction<RevertModelSnapshotAction.Request, RevertModelSnapshotAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportRevertModelSnapshotAction.class);
    private final Client client;
    private final JobManager jobManager;
    private final JobResultsProvider jobResultsProvider;
    private final JobDataCountsPersister jobDataCountsPersister;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;

    @Inject
    public TransportRevertModelSnapshotAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager, JobResultsProvider jobResultsProvider, ClusterService clusterService, Client client, JobDataCountsPersister jobDataCountsPersister) {
        super("cluster:admin/xpack/ml/job/model_snapshots/revert", transportService, clusterService, threadPool, actionFilters, RevertModelSnapshotAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.jobManager = jobManager;
        this.jobResultsProvider = jobResultsProvider;
        this.jobDataCountsPersister = jobDataCountsPersister;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
    }

    protected String executor() {
        return "same";
    }

    protected RevertModelSnapshotAction.Response read(StreamInput in) throws IOException {
        return new RevertModelSnapshotAction.Response(in);
    }

    protected void masterOperation(RevertModelSnapshotAction.Request request, ClusterState state, ActionListener<RevertModelSnapshotAction.Response> listener) {
        if (this.migrationEligibilityCheck.jobIsEligibleForMigration(request.getJobId(), state)) {
            listener.onFailure((Exception)ExceptionsHelper.configHasNotBeenMigrated((String)"revert model snapshot", (String)request.getJobId()));
            return;
        }
        logger.debug("Received request to revert to snapshot id '{}' for job '{}', deleting intervening results: {}", (Object)request.getSnapshotId(), (Object)request.getJobId(), (Object)request.getDeleteInterveningResults());
        ActionListener jobExistsListener = ActionListener.wrap(exists -> {
            PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
            JobState jobState = MlTasks.getJobState((String)request.getJobId(), (PersistentTasksCustomMetadata)tasks);
            if (!jobState.equals((Object)JobState.CLOSED)) {
                throw ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Can only revert to a model snapshot when the job is closed."), (Object[])new Object[0]);
            }
            this.getModelSnapshot(request, this.jobResultsProvider, modelSnapshot -> {
                ActionListener<RevertModelSnapshotAction.Response> wrappedListener = listener;
                if (request.getDeleteInterveningResults()) {
                    wrappedListener = this.wrapDeleteOldAnnotationsListener(wrappedListener, (ModelSnapshot)modelSnapshot, request.getJobId());
                    wrappedListener = this.wrapDeleteOldDataListener(wrappedListener, (ModelSnapshot)modelSnapshot, request.getJobId());
                    wrappedListener = this.wrapRevertDataCountsListener(wrappedListener, (ModelSnapshot)modelSnapshot, request.getJobId());
                }
                this.jobManager.revertSnapshot(request, wrappedListener, (ModelSnapshot)modelSnapshot);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener createStateIndexListener = ActionListener.wrap(r -> this.jobManager.jobExists(request.getJobId(), (ActionListener<Boolean>)jobExistsListener), arg_0 -> listener.onFailure(arg_0));
        AnomalyDetectorsIndex.createStateIndexAndAliasIfNecessary((Client)this.client, (ClusterState)state, (IndexNameExpressionResolver)this.indexNameExpressionResolver, (ActionListener)createStateIndexListener);
    }

    private void getModelSnapshot(RevertModelSnapshotAction.Request request, JobResultsProvider provider, Consumer<ModelSnapshot> handler, Consumer<Exception> errorHandler) {
        logger.info("Reverting to snapshot '" + request.getSnapshotId() + "'");
        provider.getModelSnapshot(request.getJobId(), request.getSnapshotId(), (Result<ModelSnapshot> modelSnapshot) -> {
            if (modelSnapshot == null) {
                throw new ResourceNotFoundException(Messages.getMessage((String)"No model snapshot with id [{0}] exists for job [{1}]", (Object[])new Object[]{request.getSnapshotId(), request.getJobId()}), new Object[0]);
            }
            handler.accept((ModelSnapshot)modelSnapshot.result);
        }, errorHandler);
    }

    private ActionListener<RevertModelSnapshotAction.Response> wrapDeleteOldAnnotationsListener(final ActionListener<RevertModelSnapshotAction.Response> listener, ModelSnapshot modelSnapshot, String jobId) {
        return ActionListener.wrap(response -> {
            Date deleteAfter = modelSnapshot.getLatestResultTimeStamp();
            logger.info("[{}] Removing intervening annotations after reverting model: deleting annotations after [{}]", (Object)jobId, (Object)deleteAfter);
            JobDataDeleter dataDeleter = new JobDataDeleter(this.client, jobId);
            HashSet<String> eventsToDelete = new HashSet<String>();
            eventsToDelete.add(Annotation.Event.DELAYED_DATA.toString());
            eventsToDelete.add(Annotation.Event.MODEL_CHANGE.toString());
            dataDeleter.deleteAnnotationsFromTime(deleteAfter.getTime() + 1L, eventsToDelete, new ActionListener<Boolean>(){

                public void onResponse(Boolean success) {
                    listener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private ActionListener<RevertModelSnapshotAction.Response> wrapDeleteOldDataListener(final ActionListener<RevertModelSnapshotAction.Response> listener, ModelSnapshot modelSnapshot, String jobId) {
        return ActionListener.wrap(response -> {
            Date deleteAfter = modelSnapshot.getLatestResultTimeStamp();
            logger.info("[{}] Removing intervening records after reverting model: deleting results after [{}]", (Object)jobId, (Object)deleteAfter);
            JobDataDeleter dataDeleter = new JobDataDeleter(this.client, jobId);
            dataDeleter.deleteResultsFromTime(deleteAfter.getTime() + 1L, new ActionListener<Boolean>(){

                public void onResponse(Boolean success) {
                    listener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private ActionListener<RevertModelSnapshotAction.Response> wrapRevertDataCountsListener(final ActionListener<RevertModelSnapshotAction.Response> listener, ModelSnapshot modelSnapshot, String jobId) {
        return ActionListener.wrap(response -> this.jobResultsProvider.dataCounts(jobId, counts -> {
            counts.setLatestRecordTimeStamp(modelSnapshot.getLatestRecordTimeStamp());
            this.jobDataCountsPersister.persistDataCountsAsync(jobId, (DataCounts)counts, new ActionListener<Boolean>(){

                public void onResponse(Boolean aBoolean) {
                    listener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), arg_0 -> listener.onFailure(arg_0));
    }

    protected ClusterBlockException checkBlock(RevertModelSnapshotAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

