/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public class TransportPreviewDatafeedAction
extends HandledTransportAction<PreviewDatafeedAction.Request, PreviewDatafeedAction.Response> {
    private final ThreadPool threadPool;
    private final Client client;
    private final JobConfigProvider jobConfigProvider;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobResultsProvider jobResultsProvider;
    private final NamedXContentRegistry xContentRegistry;
    private final SecurityContext securityContext;

    @Inject
    public TransportPreviewDatafeedAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, Client client, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, JobResultsProvider jobResultsProvider, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/ml/datafeeds/preview", transportService, actionFilters, PreviewDatafeedAction.Request::new);
        this.threadPool = threadPool;
        this.client = client;
        this.jobConfigProvider = jobConfigProvider;
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.jobResultsProvider = jobResultsProvider;
        this.xContentRegistry = xContentRegistry;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
    }

    protected void doExecute(Task task, PreviewDatafeedAction.Request request, final ActionListener<PreviewDatafeedAction.Response> listener) {
        this.datafeedConfigProvider.getDatafeedConfig(request.getDatafeedId(), (ActionListener<DatafeedConfig.Builder>)ActionListener.wrap(datafeedConfigBuilder -> {
            DatafeedConfig datafeedConfig = datafeedConfigBuilder.build();
            this.jobConfigProvider.getJob(datafeedConfig.getJobId(), (ActionListener<Job.Builder>)ActionListener.wrap(jobBuilder -> {
                DatafeedConfig.Builder previewDatafeed = TransportPreviewDatafeedAction.buildPreviewDatafeed(datafeedConfig);
                SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(this.securityContext, () -> {
                    previewDatafeed.setHeaders(ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders()));
                    this.jobResultsProvider.datafeedTimingStats(jobBuilder.getId(), timingStats -> DataExtractorFactory.create(this.client, previewDatafeed.build(), jobBuilder.build(), this.xContentRegistry, new DatafeedTimingStatsReporter((DatafeedTimingStats)timingStats, (ts, refreshPolicy) -> {}), new ActionListener<DataExtractorFactory>(){

                        public void onResponse(DataExtractorFactory dataExtractorFactory) {
                            DataExtractor dataExtractor = dataExtractorFactory.newExtractor(0L, Long.MAX_VALUE);
                            TransportPreviewDatafeedAction.this.threadPool.generic().execute(() -> TransportPreviewDatafeedAction.previewDatafeed(dataExtractor, (ActionListener<PreviewDatafeedAction.Response>)listener));
                        }

                        public void onFailure(Exception e) {
                            listener.onFailure(e);
                        }
                    }), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                });
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static DatafeedConfig.Builder buildPreviewDatafeed(DatafeedConfig datafeed) {
        DatafeedConfig.Builder previewDatafeed = new DatafeedConfig.Builder(datafeed);
        if (!datafeed.hasAggregations()) {
            previewDatafeed.setChunkingConfig(ChunkingConfig.newAuto());
        }
        return previewDatafeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void previewDatafeed(DataExtractor dataExtractor, ActionListener<PreviewDatafeedAction.Response> listener) {
        try {
            Optional inputStream = dataExtractor.next();
            StringBuilder responseBuilder = new StringBuilder("[");
            if (inputStream.isPresent()) {
                try (BufferedReader buffer = new BufferedReader(new InputStreamReader((InputStream)inputStream.get(), StandardCharsets.UTF_8));){
                    responseBuilder.append(buffer.lines().collect(Collectors.joining(" ")).replace("} {", "},{"));
                }
            }
            responseBuilder.append("]");
            listener.onResponse((Object)new PreviewDatafeedAction.Response((BytesReference)new BytesArray(responseBuilder.toString().getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
        finally {
            dataExtractor.cancel();
        }
    }
}

