/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.InputStream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.FindFileStructureAction;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinderManager;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;

public class TransportFindFileStructureAction
extends HandledTransportAction<FindFileStructureAction.Request, FindFileStructureAction.Response> {
    private final ThreadPool threadPool;

    @Inject
    public TransportFindFileStructureAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool) {
        super("cluster:monitor/xpack/ml/findfilestructure", transportService, actionFilters, FindFileStructureAction.Request::new);
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, FindFileStructureAction.Request request, ActionListener<FindFileStructureAction.Response> listener) {
        this.threadPool.executor("ml_utility").execute(() -> {
            try {
                listener.onResponse((Object)this.buildFileStructureResponse(request));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private FindFileStructureAction.Response buildFileStructureResponse(FindFileStructureAction.Request request) throws Exception {
        FileStructureFinderManager structureFinderManager = new FileStructureFinderManager(this.threadPool.scheduler());
        try (StreamInput sampleStream = request.getSample().streamInput();){
            FileStructureFinder fileStructureFinder = structureFinderManager.findFileStructure(request.getLinesToSample(), request.getLineMergeSizeLimit(), (InputStream)sampleStream, new FileStructureOverrides(request), request.getTimeout());
            FindFileStructureAction.Response response = new FindFileStructureAction.Response(fileStructureFinder.getStructure());
            return response;
        }
    }
}

