/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.Counter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsAction;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.Platforms;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MachineLearningFeatureSetUsage;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.stats.ForecastStats;
import org.elasticsearch.xpack.core.ml.stats.StatsAccumulator;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.job.JobManagerHolder;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.NativeControllerHolder;

public class MachineLearningFeatureSet
implements XPackFeatureSet {
    private static final List<String> mlPlatforms = Collections.unmodifiableList(Arrays.asList("darwin-x86_64", "linux-aarch64", "linux-x86_64", "windows-x86_64"));
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;
    private final Client client;
    private final JobManagerHolder jobManagerHolder;
    private final Map<String, Object> nativeCodeInfo;

    @Inject
    public MachineLearningFeatureSet(Environment environment, ClusterService clusterService, Client client, @Nullable XPackLicenseState licenseState, JobManagerHolder jobManagerHolder) {
        this.enabled = (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(environment.settings());
        this.clusterService = Objects.requireNonNull(clusterService);
        this.client = Objects.requireNonNull(client);
        this.licenseState = licenseState;
        this.jobManagerHolder = jobManagerHolder;
        Map<String, Object> nativeCodeInfo = NativeController.UNKNOWN_NATIVE_CODE_INFO;
        if (this.enabled && !XPackPlugin.transportClientMode((Settings)environment.settings())) {
            try {
                NativeController nativeController;
                if (MachineLearningFeatureSet.isRunningOnMlPlatform(true) && (nativeController = NativeControllerHolder.getNativeController(clusterService.getNodeName(), environment)) != null) {
                    nativeCodeInfo = nativeController.getNativeCodeInfo();
                }
            }
            catch (IOException | TimeoutException e) {
                LogManager.getLogger(MachineLearningFeatureSet.class).error("Cannot get native code info for Machine Learning", (Throwable)e);
                throw new ElasticsearchException("Cannot communicate with Machine Learning native code", new Object[0]);
            }
        }
        this.nativeCodeInfo = nativeCodeInfo;
    }

    static boolean isRunningOnMlPlatform(boolean fatalIfNot) {
        return MachineLearningFeatureSet.isRunningOnMlPlatform(Constants.OS_NAME, Constants.OS_ARCH, fatalIfNot);
    }

    static boolean isRunningOnMlPlatform(String osName, String osArch, boolean fatalIfNot) {
        String platformName = Platforms.platformName((String)osName, (String)osArch);
        if (mlPlatforms.contains(platformName)) {
            return true;
        }
        if (fatalIfNot) {
            throw new ElasticsearchException("X-Pack is not supported and Machine Learning is not available for [" + platformName + "]; you can use the other X-Pack features (unsupported) by setting xpack.ml.enabled: false in elasticsearch.yml", new Object[0]);
        }
        return false;
    }

    public String name() {
        return "ml";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isAllowed(XPackLicenseState.Feature.MACHINE_LEARNING);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return this.nativeCodeInfo;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        new Retriever(this.client, this.jobManagerHolder, this.available(), this.enabled(), state).execute(listener);
    }

    private static int mlNodeCount(boolean enabled, ClusterState clusterState) {
        if (!enabled) {
            return 0;
        }
        int mlNodeCount = 0;
        for (DiscoveryNode node : clusterState.getNodes()) {
            if (!MachineLearning.isMlNode(node)) continue;
            ++mlNodeCount;
        }
        return mlNodeCount;
    }

    public static class Retriever {
        private final Client client;
        private final JobManagerHolder jobManagerHolder;
        private final boolean available;
        private final boolean enabled;
        private Map<String, Object> jobsUsage;
        private Map<String, Object> datafeedsUsage;
        private Map<String, Object> analyticsUsage;
        private Map<String, Object> inferenceUsage;
        private final ClusterState state;
        private int nodeCount;

        public Retriever(Client client, JobManagerHolder jobManagerHolder, boolean available, boolean enabled, ClusterState state) {
            this.client = Objects.requireNonNull(client);
            this.jobManagerHolder = jobManagerHolder;
            this.available = available;
            this.enabled = enabled;
            this.jobsUsage = new LinkedHashMap<String, Object>();
            this.datafeedsUsage = new LinkedHashMap<String, Object>();
            this.analyticsUsage = new LinkedHashMap<String, Object>();
            this.inferenceUsage = new LinkedHashMap<String, Object>();
            this.nodeCount = MachineLearningFeatureSet.mlNodeCount(enabled, state);
            this.state = state;
        }

        private static void initializeStats(Map<String, Long> emptyStatsMap) {
            emptyStatsMap.put("sum", 0L);
            emptyStatsMap.put("min", 0L);
            emptyStatsMap.put("max", 0L);
        }

        private void addJobsUsage(GetJobsStatsAction.Response response, List<Job> jobs) {
            StatsAccumulator allJobsDetectorsStats = new StatsAccumulator();
            StatsAccumulator allJobsModelSizeStats = new StatsAccumulator();
            ForecastStats allJobsForecastStats = new ForecastStats();
            HashMap<JobState, Counter> jobCountByState = new HashMap<JobState, Counter>();
            HashMap<JobState, StatsAccumulator> detectorStatsByState = new HashMap<JobState, StatsAccumulator>();
            HashMap<JobState, StatsAccumulator> modelSizeStatsByState = new HashMap<JobState, StatsAccumulator>();
            HashMap<JobState, ForecastStats> forecastStatsByState = new HashMap<JobState, ForecastStats>();
            HashMap<JobState, Map> createdByByState = new HashMap<JobState, Map>();
            List jobsStats = response.getResponse().results();
            Map<String, Job> jobMap = jobs.stream().collect(Collectors.toMap(Job::getId, item -> item));
            Map<String, Long> allJobsCreatedBy = jobs.stream().map(this::jobCreatedBy).collect(Collectors.groupingBy(item -> item, Collectors.counting()));
            for (GetJobsStatsAction.Response.JobStats jobStats : jobsStats) {
                Job job = jobMap.get(jobStats.getJobId());
                if (job == null) continue;
                int detectorsCount = job.getAnalysisConfig().getDetectors().size();
                ModelSizeStats modelSizeStats = jobStats.getModelSizeStats();
                double modelSize = modelSizeStats == null ? 0.0 : (double)jobStats.getModelSizeStats().getModelBytes();
                allJobsForecastStats.merge(jobStats.getForecastStats());
                allJobsDetectorsStats.add((double)detectorsCount);
                allJobsModelSizeStats.add(modelSize);
                JobState jobState = jobStats.getState();
                jobCountByState.computeIfAbsent(jobState, js -> Counter.newCounter()).addAndGet(1L);
                detectorStatsByState.computeIfAbsent(jobState, js -> new StatsAccumulator()).add((double)detectorsCount);
                modelSizeStatsByState.computeIfAbsent(jobState, js -> new StatsAccumulator()).add(modelSize);
                forecastStatsByState.merge(jobState, jobStats.getForecastStats(), (f1, f2) -> f1.merge(f2));
                createdByByState.computeIfAbsent(jobState, js -> new HashMap()).compute(this.jobCreatedBy(job), (k, v) -> v == null ? 1L : v + 1L);
            }
            this.jobsUsage.put("_all", this.createJobUsageEntry(jobs.size(), allJobsDetectorsStats, allJobsModelSizeStats, allJobsForecastStats, allJobsCreatedBy));
            for (JobState jobState : jobCountByState.keySet()) {
                this.jobsUsage.put(jobState.name().toLowerCase(Locale.ROOT), this.createJobUsageEntry(((Counter)jobCountByState.get(jobState)).get(), (StatsAccumulator)detectorStatsByState.get(jobState), (StatsAccumulator)modelSizeStatsByState.get(jobState), (ForecastStats)forecastStatsByState.get(jobState), (Map)createdByByState.get(jobState)));
            }
        }

        private String jobCreatedBy(Job job) {
            Map customSettings = job.getCustomSettings();
            if (customSettings == null || !customSettings.containsKey("created_by")) {
                return "unknown";
            }
            return customSettings.get("created_by").toString().replaceAll("\\W", "_");
        }

        private Map<String, Object> createJobUsageEntry(long count, StatsAccumulator detectorStats, StatsAccumulator modelSizeStats, ForecastStats forecastStats, Map<String, Long> createdBy) {
            HashMap<String, Object> usage = new HashMap<String, Object>();
            usage.put("count", count);
            usage.put("detectors", detectorStats.asMap());
            usage.put("model_size", modelSizeStats.asMap());
            usage.put("forecasts", forecastStats.asMap());
            usage.put("created_by", createdBy);
            return usage;
        }

        private void addDatafeedsUsage(GetDatafeedsStatsAction.Response response) {
            HashMap<DatafeedState, Counter> datafeedCountByState = new HashMap<DatafeedState, Counter>();
            List datafeedsStats = response.getResponse().results();
            for (GetDatafeedsStatsAction.Response.DatafeedStats datafeedStats : datafeedsStats) {
                datafeedCountByState.computeIfAbsent(datafeedStats.getDatafeedState(), ds -> Counter.newCounter()).addAndGet(1L);
            }
            this.datafeedsUsage.put("_all", this.createCountUsageEntry(response.getResponse().count()));
            for (DatafeedState datafeedState : datafeedCountByState.keySet()) {
                this.datafeedsUsage.put(datafeedState.name().toLowerCase(Locale.ROOT), this.createCountUsageEntry(((Counter)datafeedCountByState.get(datafeedState)).get()));
            }
        }

        private Map<String, Object> createCountUsageEntry(long count) {
            HashMap<String, Object> usage = new HashMap<String, Object>();
            usage.put("count", count);
            return usage;
        }

        private void addDataFrameAnalyticsUsage(GetDataFrameAnalyticsStatsAction.Response response, Map<String, Object> dataframeAnalyticsUsage) {
            HashMap<DataFrameAnalyticsState, Counter> dataFrameAnalyticsStateCounterMap = new HashMap<DataFrameAnalyticsState, Counter>();
            for (GetDataFrameAnalyticsStatsAction.Response.Stats stats : response.getResponse().results()) {
                dataFrameAnalyticsStateCounterMap.computeIfAbsent(stats.getState(), ds -> Counter.newCounter()).addAndGet(1L);
            }
            dataframeAnalyticsUsage.put("_all", this.createCountUsageEntry(response.getResponse().count()));
            for (DataFrameAnalyticsState state : dataFrameAnalyticsStateCounterMap.keySet()) {
                dataframeAnalyticsUsage.put(state.name().toLowerCase(Locale.ROOT), this.createCountUsageEntry(((Counter)dataFrameAnalyticsStateCounterMap.get(state)).get()));
            }
        }

        private static void updateStats(Map<String, Long> statsMap, Long value) {
            statsMap.compute("sum", (k, v) -> v + value);
            statsMap.compute("min", (k, v) -> Math.min(v, value));
            statsMap.compute("max", (k, v) -> Math.max(v, value));
        }

        private static String[] ingestNodes(ClusterState clusterState) {
            String[] ingestNodes = new String[clusterState.nodes().getIngestNodes().size()];
            Iterator nodeIterator = clusterState.nodes().getIngestNodes().keysIt();
            int i = 0;
            while (nodeIterator.hasNext()) {
                ingestNodes[i++] = (String)nodeIterator.next();
            }
            return ingestNodes;
        }

        public void execute(ActionListener<XPackFeatureSet.Usage> listener) {
            if (this.jobManagerHolder.isEmpty()) {
                listener.onResponse((Object)new MachineLearningFeatureSetUsage(this.available, this.enabled, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0));
                return;
            }
            ActionListener trainedModelConfigCountListener = ActionListener.wrap(response -> {
                this.addTrainedModelStats((SearchResponse)response, this.inferenceUsage);
                MachineLearningFeatureSetUsage usage = new MachineLearningFeatureSetUsage(this.available, this.enabled, this.jobsUsage, this.datafeedsUsage, this.analyticsUsage, this.inferenceUsage, this.nodeCount);
                listener.onResponse((Object)usage);
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener nodesStatsListener = ActionListener.wrap(response -> {
                this.addInferenceIngestUsage((NodesStatsResponse)response, this.inferenceUsage);
                SearchRequestBuilder requestBuilder = this.client.prepareSearch(new String[]{".ml-inference-*"}).setSize(0).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)InferenceIndexConstants.DOC_TYPE.getPreferredName(), (String)"trained_model_config"))).setTrackTotalHits(true);
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((SearchRequest)requestBuilder.request()), (ActionListener)trainedModelConfigCountListener, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener dataframeAnalyticsListener = ActionListener.wrap(response -> {
                this.addDataFrameAnalyticsUsage((GetDataFrameAnalyticsStatsAction.Response)response, this.analyticsUsage);
                String[] ingestNodes = Retriever.ingestNodes(this.state);
                NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(ingestNodes).clear().addMetric(NodesStatsRequest.Metric.INGEST.metricName());
                this.client.execute((ActionType)NodesStatsAction.INSTANCE, (ActionRequest)nodesStatsRequest, nodesStatsListener);
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener datafeedStatsListener = ActionListener.wrap(response -> {
                this.addDatafeedsUsage((GetDatafeedsStatsAction.Response)response);
                GetDataFrameAnalyticsStatsAction.Request dataframeAnalyticsStatsRequest = new GetDataFrameAnalyticsStatsAction.Request("_all");
                dataframeAnalyticsStatsRequest.setPageParams(new PageParams(0, 10000));
                this.client.execute((ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, (ActionRequest)dataframeAnalyticsStatsRequest, dataframeAnalyticsListener);
            }, arg_0 -> listener.onFailure(arg_0));
            GetJobsStatsAction.Request jobStatsRequest = new GetJobsStatsAction.Request("_all");
            ActionListener jobStatsListener = ActionListener.wrap(response -> this.jobManagerHolder.getJobManager().expandJobs("_all", true, (ActionListener<QueryPage<Job>>)ActionListener.wrap(jobs -> {
                this.addJobsUsage((GetJobsStatsAction.Response)response, jobs.results());
                GetDatafeedsStatsAction.Request datafeedStatsRequest = new GetDatafeedsStatsAction.Request("_all");
                this.client.execute((ActionType)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)datafeedStatsRequest, datafeedStatsListener);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
            this.client.execute((ActionType)GetJobsStatsAction.INSTANCE, (ActionRequest)jobStatsRequest, jobStatsListener);
        }

        private void addTrainedModelStats(SearchResponse response, Map<String, Object> inferenceUsage) {
            inferenceUsage.put("trained_models", Collections.singletonMap("_all", this.createCountUsageEntry(response.getHits().getTotalHits().value)));
        }

        private void addInferenceIngestUsage(NodesStatsResponse response, Map<String, Object> inferenceUsage) {
            HashSet pipelines = new HashSet();
            HashMap<String, Long> docCountStats = new HashMap<String, Long>(3);
            HashMap<String, Long> timeStats = new HashMap<String, Long>(3);
            HashMap<String, Long> failureStats = new HashMap<String, Long>(3);
            Retriever.initializeStats(docCountStats);
            Retriever.initializeStats(timeStats);
            Retriever.initializeStats(failureStats);
            response.getNodes().stream().map(NodeStats::getIngestStats).map(IngestStats::getProcessorStats).forEach(map -> map.forEach((pipelineId, processors) -> {
                boolean containsInference = false;
                for (IngestStats.ProcessorStat stats : processors) {
                    if (!stats.getName().equals("inference")) continue;
                    containsInference = true;
                    long ingestCount = stats.getStats().getIngestCount();
                    long ingestTime = stats.getStats().getIngestTimeInMillis();
                    long failureCount = stats.getStats().getIngestFailedCount();
                    Retriever.updateStats(docCountStats, ingestCount);
                    Retriever.updateStats(timeStats, ingestTime);
                    Retriever.updateStats(failureStats, failureCount);
                }
                if (containsInference) {
                    pipelines.add(pipelineId);
                }
            }));
            HashMap<String, Map<String, Object>> ingestUsage = new HashMap<String, Map<String, Object>>(6);
            ingestUsage.put("pipelines", this.createCountUsageEntry(pipelines.size()));
            ingestUsage.put("num_docs_processed", docCountStats);
            ingestUsage.put("time_ms", timeStats);
            ingestUsage.put("num_failures", failureStats);
            inferenceUsage.put("ingest_processors", Collections.singletonMap("_all", ingestUsage));
        }
    }
}

