/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.slm.SnapshotRetentionService;

public class TransportExecuteSnapshotRetentionAction
extends TransportMasterNodeAction<ExecuteSnapshotRetentionAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportExecuteSnapshotRetentionAction.class);
    private final SnapshotRetentionService retentionService;

    @Inject
    public TransportExecuteSnapshotRetentionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SnapshotRetentionService retentionService) {
        super("cluster:admin/slm/execute-retention", transportService, clusterService, threadPool, actionFilters, ExecuteSnapshotRetentionAction.Request::new, indexNameExpressionResolver);
        this.retentionService = retentionService;
    }

    protected String executor() {
        return "generic";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(ExecuteSnapshotRetentionAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        try {
            logger.info("manually triggering SLM snapshot retention");
            this.retentionService.triggerRetention();
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }
        catch (Exception e) {
            listener.onFailure((Exception)new ElasticsearchException("failed to execute snapshot lifecycle retention", (Throwable)e, new Object[0]));
        }
    }

    protected ClusterBlockException checkBlock(ExecuteSnapshotRetentionAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

