/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.action.RemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;

public class TransportRemoveIndexLifecyclePolicyAction
extends TransportMasterNodeAction<RemoveIndexLifecyclePolicyAction.Request, RemoveIndexLifecyclePolicyAction.Response> {
    @Inject
    public TransportRemoveIndexLifecyclePolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/ilm/remove_policy", transportService, clusterService, threadPool, actionFilters, RemoveIndexLifecyclePolicyAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected RemoveIndexLifecyclePolicyAction.Response read(StreamInput in) throws IOException {
        return new RemoveIndexLifecyclePolicyAction.Response(in);
    }

    protected ClusterBlockException checkBlock(RemoveIndexLifecyclePolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(RemoveIndexLifecyclePolicyAction.Request request, ClusterState state, final ActionListener<RemoveIndexLifecyclePolicyAction.Response> listener) throws Exception {
        final Index[] indices = this.indexNameExpressionResolver.concreteIndices(state, request.indicesOptions(), true, request.indices());
        this.clusterService.submitStateUpdateTask("remove-lifecycle-for-index", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<RemoveIndexLifecyclePolicyAction.Response>((AckedRequest)request, listener){
            private final List<String> failedIndexes;
            {
                super(arg0, arg1);
                this.failedIndexes = new ArrayList<String>();
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                return IndexLifecycleTransition.removePolicyForIndexes(indices, currentState, this.failedIndexes);
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            protected RemoveIndexLifecyclePolicyAction.Response newResponse(boolean acknowledged) {
                return new RemoveIndexLifecyclePolicyAction.Response(this.failedIndexes);
            }
        });
    }
}

