/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.time.Instant;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;

public class TransportPutLifecycleAction
extends TransportMasterNodeAction<PutLifecycleAction.Request, PutLifecycleAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutLifecycleAction.class);
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;

    @Inject
    public TransportPutLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry namedXContentRegistry, Client client) {
        super("cluster:admin/ilm/put", transportService, clusterService, threadPool, actionFilters, PutLifecycleAction.Request::new, indexNameExpressionResolver);
        this.xContentRegistry = namedXContentRegistry;
        this.client = client;
    }

    protected String executor() {
        return "same";
    }

    protected PutLifecycleAction.Response read(StreamInput in) throws IOException {
        return new PutLifecycleAction.Response(in);
    }

    protected void masterOperation(final PutLifecycleAction.Request request, ClusterState state, ActionListener<PutLifecycleAction.Response> listener) {
        final Map filteredHeaders = ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders());
        LifecyclePolicy.validatePolicyName((String)request.getPolicy().getName());
        this.clusterService.submitStateUpdateTask("put-lifecycle-" + request.getPolicy().getName(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PutLifecycleAction.Response>((AckedRequest)request, listener){

            protected PutLifecycleAction.Response newResponse(boolean acknowledged) {
                return new PutLifecycleAction.Response(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                LifecyclePolicyMetadata lifecyclePolicyMetadata;
                LifecyclePolicyMetadata existingPolicyMetadata;
                ClusterState.Builder stateBuilder = ClusterState.builder((ClusterState)currentState);
                IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle");
                if (currentMetadata == null) {
                    currentMetadata = IndexLifecycleMetadata.EMPTY;
                }
                long nextVersion = (existingPolicyMetadata = (LifecyclePolicyMetadata)currentMetadata.getPolicyMetadatas().get(request.getPolicy().getName())) == null ? 1L : existingPolicyMetadata.getVersion() + 1L;
                TreeMap<String, LifecyclePolicyMetadata> newPolicies = new TreeMap<String, LifecyclePolicyMetadata>(currentMetadata.getPolicyMetadatas());
                LifecyclePolicyMetadata oldPolicy = newPolicies.put((lifecyclePolicyMetadata = new LifecyclePolicyMetadata(request.getPolicy(), filteredHeaders, nextVersion, Instant.now().toEpochMilli())).getName(), lifecyclePolicyMetadata);
                if (oldPolicy == null) {
                    logger.info("adding index lifecycle policy [{}]", (Object)request.getPolicy().getName());
                } else {
                    logger.info("updating index lifecycle policy [{}]", (Object)request.getPolicy().getName());
                }
                IndexLifecycleMetadata newMetadata = new IndexLifecycleMetadata(newPolicies, currentMetadata.getOperationMode());
                stateBuilder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("index_lifecycle", (Metadata.Custom)newMetadata).build());
                ClusterState nonRefreshedState = stateBuilder.build();
                if (oldPolicy == null) {
                    return nonRefreshedState;
                }
                try {
                    return TransportPutLifecycleAction.updateIndicesForPolicy(nonRefreshedState, TransportPutLifecycleAction.this.xContentRegistry, TransportPutLifecycleAction.this.client, oldPolicy.getPolicy(), lifecyclePolicyMetadata);
                }
                catch (Exception e) {
                    logger.warn((Message)new ParameterizedMessage("unable to refresh indices phase JSON for updated policy [{}]", (Object)oldPolicy.getName()), (Throwable)e);
                    return nonRefreshedState;
                }
            }
        });
    }

    static boolean eligibleToCheckForRefresh(IndexMetadata metadata) {
        LifecycleExecutionState executionState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)metadata);
        if (executionState == null || executionState.getPhaseDefinition() == null) {
            return false;
        }
        Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)executionState);
        if (currentStepKey == null || currentStepKey.getPhase() == null) {
            return false;
        }
        return !"ERROR".equals(currentStepKey.getName());
    }

    @Nullable
    static Set<Step.StepKey> readStepKeys(NamedXContentRegistry xContentRegistry, Client client, String phaseDef, String currentPhase) {
        PhaseExecutionInfo phaseExecutionInfo;
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, phaseDef);){
            phaseExecutionInfo = PhaseExecutionInfo.parse((XContentParser)parser, (String)currentPhase);
        }
        catch (Exception e) {
            logger.trace((Message)new ParameterizedMessage("exception reading step keys checking for refreshability, phase definition: {}", (Object)phaseDef), (Throwable)e);
            return null;
        }
        if (phaseExecutionInfo == null || phaseExecutionInfo.getPhase() == null) {
            return null;
        }
        return phaseExecutionInfo.getPhase().getActions().values().stream().flatMap(a -> a.toSteps(client, phaseExecutionInfo.getPhase().getName(), null).stream()).map(Step::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static boolean isIndexPhaseDefinitionUpdatable(NamedXContentRegistry xContentRegistry, Client client, IndexMetadata metadata, LifecyclePolicy newPolicy) {
        String index = metadata.getIndex().getName();
        if (!TransportPutLifecycleAction.eligibleToCheckForRefresh(metadata)) {
            logger.debug("[{}] does not contain enough information to check for eligibility of refreshing phase", (Object)index);
            return false;
        }
        String policyId = newPolicy.getName();
        LifecycleExecutionState executionState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)metadata);
        Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)executionState);
        String currentPhase = currentStepKey.getPhase();
        Set newStepKeys = newPolicy.toSteps(client).stream().map(Step::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!newStepKeys.contains(currentStepKey)) {
            logger.debug("[{}] updated policy [{}] does not contain the current step key [{}], so the policy phase will not be refreshed", (Object)index, (Object)policyId, (Object)currentStepKey);
            return false;
        }
        String phaseDef = executionState.getPhaseDefinition();
        Set<Step.StepKey> oldStepKeys = TransportPutLifecycleAction.readStepKeys(xContentRegistry, client, phaseDef, currentPhase);
        if (oldStepKeys == null) {
            logger.debug("[{}] unable to parse phase definition for cached policy [{}], policy phase will not be refreshed", (Object)index, (Object)policyId);
            return false;
        }
        Set oldPhaseStepKeys = oldStepKeys.stream().filter(sk -> currentPhase.equals(sk.getPhase())).collect(Collectors.toCollection(LinkedHashSet::new));
        PhaseExecutionInfo phaseExecutionInfo = new PhaseExecutionInfo(policyId, (Phase)newPolicy.getPhases().get(currentPhase), 1L, 1L);
        String peiJson = Strings.toString((ToXContent)phaseExecutionInfo);
        Set<Step.StepKey> newPhaseStepKeys = TransportPutLifecycleAction.readStepKeys(xContentRegistry, client, peiJson, currentPhase);
        if (newPhaseStepKeys == null) {
            logger.debug((Message)new ParameterizedMessage("[{}] unable to parse phase definition for policy [{}] to determine if it could be refreshed", (Object)index, (Object)policyId));
            return false;
        }
        if (newPhaseStepKeys.equals(oldPhaseStepKeys)) {
            logger.debug("[{}] updated policy [{}] contains the same phase step keys and can be refreshed", (Object)index, (Object)policyId);
            return true;
        }
        logger.debug("[{}] updated policy [{}] has different phase step keys and will NOT refresh phase definition as it differs too greatly. old: {}, new: {}", (Object)index, (Object)policyId, (Object)oldPhaseStepKeys, newPhaseStepKeys);
        return false;
    }

    static ClusterState refreshPhaseDefinition(ClusterState state, String index, LifecyclePolicyMetadata updatedPolicy) {
        IndexMetadata idxMeta = state.metadata().index(index);
        assert (TransportPutLifecycleAction.eligibleToCheckForRefresh(idxMeta)) : "index " + index + " is missing crucial information needed to refresh phase definition";
        logger.trace("[{}] updating cached phase definition for policy [{}]", (Object)index, (Object)updatedPolicy.getName());
        LifecycleExecutionState currentExState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)idxMeta);
        String currentPhase = currentExState.getPhase();
        PhaseExecutionInfo pei = new PhaseExecutionInfo(updatedPolicy.getName(), (Phase)updatedPolicy.getPolicy().getPhases().get(currentPhase), updatedPolicy.getVersion(), updatedPolicy.getModifiedDate());
        LifecycleExecutionState newExState = LifecycleExecutionState.builder((LifecycleExecutionState)currentExState).setPhaseDefinition(Strings.toString((ToXContent)pei, (boolean)false, (boolean)false)).build();
        return IndexLifecycleTransition.newClusterStateWithLifecycleState(idxMeta.getIndex(), state, newExState).build();
    }

    static ClusterState updateIndicesForPolicy(ClusterState state, NamedXContentRegistry xContentRegistry, Client client, LifecyclePolicy oldPolicy, LifecyclePolicyMetadata newPolicy) {
        assert (oldPolicy.getName().equals(newPolicy.getName())) : "expected both policies to have the same id but they were: [" + oldPolicy.getName() + "] vs. [" + newPolicy.getName() + "]";
        if (oldPolicy.equals((Object)newPolicy.getPolicy())) {
            logger.debug("policy [{}] is unchanged and no phase definition refresh is needed", (Object)oldPolicy.getName());
            return state;
        }
        List indicesThatCanBeUpdated = StreamSupport.stream(Spliterators.spliteratorUnknownSize(state.metadata().indices().valuesIt(), 0), false).filter(meta -> newPolicy.getName().equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(meta.getSettings()))).filter(meta -> TransportPutLifecycleAction.isIndexPhaseDefinitionUpdatable(xContentRegistry, client, meta, newPolicy.getPolicy())).map(meta -> meta.getIndex().getName()).collect(Collectors.toList());
        ClusterState updatedState = state;
        for (String index : indicesThatCanBeUpdated) {
            try {
                updatedState = TransportPutLifecycleAction.refreshPhaseDefinition(updatedState, index, newPolicy);
            }
            catch (Exception e) {
                logger.warn((Message)new ParameterizedMessage("[{}] unable to refresh phase definition for updated policy [{}]", (Object)index, (Object)newPolicy.getName()), (Throwable)e);
            }
        }
        return updatedState;
    }

    protected ClusterBlockException checkBlock(PutLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

