/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleFeatureSetUsage;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;

public class IndexLifecycleFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;
    private ClusterService clusterService;

    @Inject
    public IndexLifecycleFeatureSet(@Nullable XPackLicenseState licenseState, ClusterService clusterService) {
        this.clusterService = clusterService;
        this.licenseState = licenseState;
    }

    public String name() {
        return "ilm";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isAllowed(XPackLicenseState.Feature.ILM);
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        Metadata metadata = this.clusterService.state().metadata();
        IndexLifecycleMetadata lifecycleMetadata = (IndexLifecycleMetadata)metadata.custom("index_lifecycle");
        if (this.enabled() && lifecycleMetadata != null) {
            HashMap policyUsage = new HashMap();
            metadata.indices().forEach(entry -> {
                String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(((IndexMetadata)entry.value).getSettings());
                Integer indicesManaged = (Integer)policyUsage.get(policyName);
                indicesManaged = indicesManaged == null ? Integer.valueOf(1) : Integer.valueOf(indicesManaged + 1);
                policyUsage.put(policyName, indicesManaged);
            });
            List policyStats = lifecycleMetadata.getPolicies().values().stream().map(policy -> {
                Map<String, IndexLifecycleFeatureSetUsage.PhaseStats> phaseStats = policy.getPhases().values().stream().map(phase -> {
                    String[] actionNames = phase.getActions().keySet().toArray(new String[phase.getActions().size()]);
                    return new Tuple((Object)phase.getName(), (Object)new IndexLifecycleFeatureSetUsage.PhaseStats(phase.getMinimumAge(), actionNames));
                }).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
                return new IndexLifecycleFeatureSetUsage.PolicyStats(phaseStats, policyUsage.getOrDefault(policy.getName(), 0).intValue());
            }).collect(Collectors.toList());
            listener.onResponse((Object)new IndexLifecycleFeatureSetUsage(this.available(), policyStats));
        } else {
            listener.onResponse((Object)new IndexLifecycleFeatureSetUsage(this.available()));
        }
    }
}

