/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.support;

import java.io.IOException;
import java.util.function.LongSupplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.MissingValues;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexGeoShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.MultiGeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSource;

public class GeoShapeValuesSourceType
implements Writeable,
ValuesSourceType {
    static GeoShapeValuesSourceType INSTANCE = new GeoShapeValuesSourceType();

    public static GeoShapeValuesSourceType instance() {
        return INSTANCE;
    }

    public ValuesSource getEmpty() {
        return GeoShapeValuesSource.EMPTY;
    }

    public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
        throw new UnsupportedOperationException("geo_shape");
    }

    public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
        boolean isGeoPoint = fieldContext.indexFieldData() instanceof IndexGeoPointFieldData;
        boolean isGeoShape = fieldContext.indexFieldData() instanceof IndexGeoShapeFieldData;
        if (!isGeoPoint && !isGeoShape) {
            throw new IllegalArgumentException("Expected geo_point or geo_shape type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
        }
        if (isGeoPoint) {
            return new ValuesSource.GeoPoint.Fielddata((IndexGeoPointFieldData)fieldContext.indexFieldData());
        }
        return new GeoShapeValuesSource.Fielddata((IndexGeoShapeFieldData)fieldContext.indexFieldData());
    }

    public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier now) {
        final GeoShapeValuesSource geoShapeValuesSource = (GeoShapeValuesSource)valuesSource;
        final MultiGeoShapeValues.GeoShapeValue missing = MultiGeoShapeValues.GeoShapeValue.missing(rawMissing.toString());
        return new GeoShapeValuesSource(){

            @Override
            public MultiGeoShapeValues geoShapeValues(LeafReaderContext context) {
                final MultiGeoShapeValues values = geoShapeValuesSource.geoShapeValues(context);
                return new MultiGeoShapeValues(){
                    private int count;

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        this.count = values.advanceExact(doc) ? values.docValueCount() : 0;
                        return true;
                    }

                    @Override
                    public int docValueCount() {
                        return this.count == 0 ? 1 : this.count;
                    }

                    @Override
                    public ValuesSourceType valuesSourceType() {
                        return values.valuesSourceType();
                    }

                    @Override
                    public MultiGeoShapeValues.GeoShapeValue nextValue() throws IOException {
                        if (this.count > 0) {
                            return values.nextValue();
                        }
                        return missing;
                    }

                    public String toString() {
                        return "anon MultiGeoShapeValues of [" + super.toString() + "]";
                    }
                };
            }

            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return MissingValues.replaceMissing((SortedBinaryDocValues)geoShapeValuesSource.bytesValues(context), (BytesRef)new BytesRef((CharSequence)missing.toString()));
            }
        };
    }

    public String typeName() {
        return "geoshape";
    }

    public void writeTo(StreamOutput out) throws IOException {
    }
}

