/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.elasticsearch.xpack.spatial.index.fielddata.MultiGeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.ByteTrackingSortingNumericDocValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;

class GeoShapeCellValues
extends ByteTrackingSortingNumericDocValues {
    private final MultiGeoShapeValues geoShapeValues;
    protected int precision;
    protected GeoGridTiler tiler;

    protected GeoShapeCellValues(MultiGeoShapeValues geoShapeValues, int precision, GeoGridTiler tiler, LongConsumer circuitBreakerConsumer) {
        super(circuitBreakerConsumer);
        this.geoShapeValues = geoShapeValues;
        this.precision = precision;
        this.tiler = tiler;
    }

    public boolean advanceExact(int docId) throws IOException {
        if (this.geoShapeValues.advanceExact(docId)) {
            assert (this.geoShapeValues.docValueCount() == 1);
            int j = this.advanceValue(this.geoShapeValues.nextValue());
            this.resize(j);
            this.sort();
            return true;
        }
        return false;
    }

    protected long[] getValues() {
        return this.values;
    }

    void resizeCell(int newSize) {
        this.resize(newSize);
    }

    protected void add(int idx, long value) {
        this.values[idx] = value;
    }

    int advanceValue(MultiGeoShapeValues.GeoShapeValue target) {
        return this.tiler.setValues(this, target, this.precision);
    }
}

