/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.MultiGeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoTileGridTiler;

public class BoundedGeoTileGridTiler
extends GeoTileGridTiler {
    private final double boundsTop;
    private final double boundsBottom;
    private final double boundsWestLeft;
    private final double boundsWestRight;
    private final double boundsEastLeft;
    private final double boundsEastRight;
    private final boolean crossesDateline;

    public BoundedGeoTileGridTiler(GeoBoundingBox geoBoundingBox) {
        this.boundsTop = geoBoundingBox.top();
        this.boundsBottom = geoBoundingBox.bottom();
        if (geoBoundingBox.right() < geoBoundingBox.left()) {
            this.boundsWestLeft = -180.0;
            this.boundsWestRight = geoBoundingBox.right();
            this.boundsEastLeft = geoBoundingBox.left();
            this.boundsEastRight = 180.0;
            this.crossesDateline = true;
        } else {
            this.boundsEastLeft = geoBoundingBox.left();
            this.boundsEastRight = geoBoundingBox.right();
            this.boundsWestLeft = 0.0;
            this.boundsWestRight = 0.0;
            this.crossesDateline = false;
        }
    }

    @Override
    public int advancePointValue(long[] values, double x, double y, int precision, int valuesIdx) {
        long hash = this.encode(x, y, precision);
        if (this.cellIntersectsGeoBoundingBox(GeoTileUtils.toBoundingBox((long)hash))) {
            values[valuesIdx] = hash;
            return valuesIdx + 1;
        }
        return valuesIdx;
    }

    boolean cellIntersectsGeoBoundingBox(Rectangle rectangle) {
        return this.boundsTop >= rectangle.getMinY() && this.boundsBottom <= rectangle.getMaxY() && (this.boundsEastLeft <= rectangle.getMaxX() && this.boundsEastRight >= rectangle.getMinX() || this.crossesDateline && this.boundsWestLeft <= rectangle.getMaxX() && this.boundsWestRight >= rectangle.getMinX());
    }

    @Override
    public GeoRelation relateTile(MultiGeoShapeValues.GeoShapeValue geoValue, int xTile, int yTile, int precision) {
        Rectangle rectangle = GeoTileUtils.toBoundingBox((int)xTile, (int)yTile, (int)precision);
        if (this.cellIntersectsGeoBoundingBox(rectangle)) {
            return geoValue.relate(rectangle);
        }
        return GeoRelation.QUERY_DISJOINT;
    }

    @Override
    protected int setValue(GeoShapeCellValues docValues, MultiGeoShapeValues.GeoShapeValue geoValue, int xTile, int yTile, int precision) {
        if (this.cellIntersectsGeoBoundingBox(GeoTileUtils.toBoundingBox((int)xTile, (int)yTile, (int)precision))) {
            docValues.resizeCell(1);
            docValues.add(0, GeoTileUtils.longEncodeTiles((int)precision, (long)xTile, (long)yTile));
            return 1;
        }
        return 0;
    }

    @Override
    protected int setValuesForFullyContainedTile(int xTile, int yTile, int zTile, GeoShapeCellValues values, int valuesIndex, int targetPrecision) {
        ++zTile;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int nextX = 2 * xTile + i;
                int nextY = 2 * yTile + j;
                if (zTile == targetPrecision) {
                    if (!this.cellIntersectsGeoBoundingBox(GeoTileUtils.toBoundingBox((int)nextX, (int)nextY, (int)zTile))) continue;
                    values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)zTile, (long)nextX, (long)nextY));
                    continue;
                }
                valuesIndex = this.setValuesForFullyContainedTile(nextX, nextY, zTile, values, valuesIndex, targetPrecision);
            }
        }
        return valuesIndex;
    }
}

