/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.GeographyValidator;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.CentroidCalculator;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.DimensionalShapeType;
import org.elasticsearch.xpack.spatial.index.fielddata.Extent;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeCoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.TriangleTreeReader;
import org.elasticsearch.xpack.spatial.index.fielddata.TriangleTreeWriter;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public abstract class MultiGeoShapeValues {
    public static MultiGeoShapeValues EMPTY = new MultiGeoShapeValues(){
        private GeoShapeValuesSourceType DEFAULT_VALUES_SOURCE_TYPE = GeoShapeValuesSourceType.instance();

        @Override
        public boolean advanceExact(int doc) {
            return false;
        }

        @Override
        public int docValueCount() {
            return 0;
        }

        @Override
        public ValuesSourceType valuesSourceType() {
            return this.DEFAULT_VALUES_SOURCE_TYPE;
        }

        @Override
        public GeoShapeValue nextValue() {
            throw new UnsupportedOperationException();
        }
    };

    protected MultiGeoShapeValues() {
    }

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract int docValueCount();

    public abstract ValuesSourceType valuesSourceType();

    public abstract GeoShapeValue nextValue() throws IOException;

    public static class BoundingBox {
        public double top;
        public double bottom;
        public double negLeft;
        public double negRight;
        public double posLeft;
        public double posRight;

        private BoundingBox() {
        }

        private void reset(Extent extent, CoordinateEncoder coordinateEncoder) {
            this.top = coordinateEncoder.decodeY(extent.top);
            this.bottom = coordinateEncoder.decodeY(extent.bottom);
            if (extent.negLeft == Integer.MAX_VALUE && extent.negRight == Integer.MIN_VALUE) {
                this.negLeft = Double.POSITIVE_INFINITY;
                this.negRight = Double.NEGATIVE_INFINITY;
            } else {
                this.negLeft = coordinateEncoder.decodeX(extent.negLeft);
                this.negRight = coordinateEncoder.decodeX(extent.negRight);
            }
            if (extent.posLeft == Integer.MAX_VALUE && extent.posRight == Integer.MIN_VALUE) {
                this.posLeft = Double.POSITIVE_INFINITY;
                this.posRight = Double.NEGATIVE_INFINITY;
            } else {
                this.posLeft = coordinateEncoder.decodeX(extent.posLeft);
                this.posRight = coordinateEncoder.decodeX(extent.posRight);
            }
        }

        private void reset(GeoPoint point) {
            this.top = point.lat();
            this.bottom = point.lat();
            if (point.lon() < 0.0) {
                this.negLeft = point.lon();
                this.negRight = point.lon();
                this.posLeft = Double.POSITIVE_INFINITY;
                this.posRight = Double.NEGATIVE_INFINITY;
            } else {
                this.negLeft = Double.POSITIVE_INFINITY;
                this.negRight = Double.NEGATIVE_INFINITY;
                this.posLeft = point.lon();
                this.posRight = point.lon();
            }
        }

        public double minY() {
            return this.bottom;
        }

        public double maxY() {
            return this.top;
        }

        public double minX() {
            return Math.min(this.negLeft, this.posLeft);
        }

        public double maxX() {
            return Math.max(this.negRight, this.posRight);
        }
    }

    public static class GeoShapeValue {
        private static final WellKnownText MISSING_GEOMETRY_PARSER = new WellKnownText(true, (GeometryValidator)new GeographyValidator(true));
        private final TriangleTreeReader reader;
        private final BoundingBox boundingBox;

        public GeoShapeValue(TriangleTreeReader reader) {
            this.reader = reader;
            this.boundingBox = new BoundingBox();
        }

        public BoundingBox boundingBox() {
            this.boundingBox.reset(this.reader.getExtent(), GeoShapeCoordinateEncoder.INSTANCE);
            return this.boundingBox;
        }

        public GeoRelation relate(Rectangle rectangle) {
            int minX = GeoShapeCoordinateEncoder.INSTANCE.encodeX(rectangle.getMinX());
            int maxX = GeoShapeCoordinateEncoder.INSTANCE.encodeX(rectangle.getMaxX());
            int minY = GeoShapeCoordinateEncoder.INSTANCE.encodeY(rectangle.getMinY());
            int maxY = GeoShapeCoordinateEncoder.INSTANCE.encodeY(rectangle.getMaxY());
            return this.reader.relateTile(minX, minY, maxX, maxY);
        }

        public DimensionalShapeType dimensionalShapeType() {
            return this.reader.getDimensionalShapeType();
        }

        public double weight() {
            return this.reader.getSumCentroidWeight();
        }

        public double lat() {
            return this.reader.getCentroidY();
        }

        public double lon() {
            return this.reader.getCentroidX();
        }

        public static GeoShapeValue missing(String missing) {
            try {
                Geometry geometry = MISSING_GEOMETRY_PARSER.fromWKT(missing);
                ShapeField.DecodedTriangle[] triangles = GeoShapeValue.toDecodedTriangles(geometry);
                TriangleTreeWriter writer = new TriangleTreeWriter(Arrays.asList(triangles), GeoShapeCoordinateEncoder.INSTANCE, new CentroidCalculator(geometry));
                ByteBuffersDataOutput output = new ByteBuffersDataOutput();
                writer.writeTo(output);
                TriangleTreeReader reader = new TriangleTreeReader(GeoShapeCoordinateEncoder.INSTANCE);
                reader.reset(new BytesRef(output.toArrayCopy(), 0, Math.toIntExact(output.size())));
                return new GeoShapeValue(reader);
            }
            catch (IOException | ParseException e) {
                throw new IllegalArgumentException("Can't apply missing value [" + missing + "]", e);
            }
        }

        private static ShapeField.DecodedTriangle[] toDecodedTriangles(Geometry geometry) {
            GeoShapeIndexer indexer = new GeoShapeIndexer(true, "test");
            geometry = indexer.prepareForIndexing(geometry);
            List fields = indexer.indexShape(null, geometry);
            ShapeField.DecodedTriangle[] triangles = new ShapeField.DecodedTriangle[fields.size()];
            byte[] scratch = new byte[28];
            for (int i = 0; i < fields.size(); ++i) {
                BytesRef bytesRef = ((IndexableField)fields.get(i)).binaryValue();
                assert (bytesRef.length == 28);
                System.arraycopy(bytesRef.bytes, bytesRef.offset, scratch, 0, 28);
                triangles[i] = new ShapeField.DecodedTriangle();
                ShapeField.decodeTriangle((byte[])scratch, (ShapeField.DecodedTriangle)triangles[i]);
            }
            return triangles;
        }
    }
}

