/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.AbstractAtomicGeoShapeShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeCoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.MultiGeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.TriangleTreeReader;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

final class LatLonShapeDVAtomicShapeFieldData
extends AbstractAtomicGeoShapeShapeFieldData {
    private final LeafReader reader;
    private final String fieldName;

    LatLonShapeDVAtomicShapeFieldData(LeafReader reader, String fieldName) {
        this.reader = reader;
        this.fieldName = fieldName;
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public void close() {
    }

    @Override
    public MultiGeoShapeValues getGeoShapeValues() {
        try {
            final BinaryDocValues binaryValues = DocValues.getBinary((LeafReader)this.reader, (String)this.fieldName);
            final TriangleTreeReader reader = new TriangleTreeReader(GeoShapeCoordinateEncoder.INSTANCE);
            final MultiGeoShapeValues.GeoShapeValue geoShapeValue = new MultiGeoShapeValues.GeoShapeValue(reader);
            return new MultiGeoShapeValues(){

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return binaryValues.advanceExact(doc);
                }

                @Override
                public int docValueCount() {
                    return 1;
                }

                @Override
                public ValuesSourceType valuesSourceType() {
                    return GeoShapeValuesSourceType.instance();
                }

                @Override
                public MultiGeoShapeValues.GeoShapeValue nextValue() throws IOException {
                    BytesRef encoded = binaryValues.binaryValue();
                    reader.reset(encoded);
                    return geoShapeValue;
                }
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }
}

