/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.spatial.index.fielddata.DimensionalShapeType;
import org.elasticsearch.xpack.spatial.index.fielddata.MultiGeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSource;

public final class GeoShapeCentroidAggregator
extends MetricsAggregator {
    private final GeoShapeValuesSource valuesSource;
    private DoubleArray lonSum;
    private DoubleArray lonCompensations;
    private DoubleArray latSum;
    private DoubleArray latCompensations;
    private DoubleArray weightSum;
    private DoubleArray weightCompensations;
    private LongArray counts;
    private ByteArray dimensionalShapeTypes;

    public GeoShapeCentroidAggregator(String name, SearchContext context, Aggregator parent, ValuesSourceConfig valuesSourceConfig, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        GeoShapeValuesSource geoShapeValuesSource = this.valuesSource = valuesSourceConfig.hasValues() ? (GeoShapeValuesSource)valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.lonSum = bigArrays.newDoubleArray(1L, true);
            this.lonCompensations = bigArrays.newDoubleArray(1L, true);
            this.latSum = bigArrays.newDoubleArray(1L, true);
            this.latCompensations = bigArrays.newDoubleArray(1L, true);
            this.weightSum = bigArrays.newDoubleArray(1L, true);
            this.weightCompensations = bigArrays.newDoubleArray(1L, true);
            this.counts = bigArrays.newLongArray(1L, true);
            this.dimensionalShapeTypes = bigArrays.newByteArray(1L, true);
        }
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final MultiGeoShapeValues values = this.valuesSource.geoShapeValues(ctx);
        final CompensatedSum compensatedSumLat = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumLon = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumWeight = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                GeoShapeCentroidAggregator.this.latSum = bigArrays.grow(GeoShapeCentroidAggregator.this.latSum, bucket + 1L);
                GeoShapeCentroidAggregator.this.lonSum = bigArrays.grow(GeoShapeCentroidAggregator.this.lonSum, bucket + 1L);
                GeoShapeCentroidAggregator.this.weightSum = bigArrays.grow(GeoShapeCentroidAggregator.this.weightSum, bucket + 1L);
                GeoShapeCentroidAggregator.this.lonCompensations = bigArrays.grow(GeoShapeCentroidAggregator.this.lonCompensations, bucket + 1L);
                GeoShapeCentroidAggregator.this.latCompensations = bigArrays.grow(GeoShapeCentroidAggregator.this.latCompensations, bucket + 1L);
                GeoShapeCentroidAggregator.this.weightCompensations = bigArrays.grow(GeoShapeCentroidAggregator.this.weightCompensations, bucket + 1L);
                GeoShapeCentroidAggregator.this.counts = bigArrays.grow(GeoShapeCentroidAggregator.this.counts, bucket + 1L);
                GeoShapeCentroidAggregator.this.dimensionalShapeTypes = bigArrays.grow(GeoShapeCentroidAggregator.this.dimensionalShapeTypes, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    GeoShapeCentroidAggregator.this.counts.increment(bucket, (long)valueCount);
                    DimensionalShapeType shapeType = DimensionalShapeType.fromOrdinalByte(GeoShapeCentroidAggregator.this.dimensionalShapeTypes.get(bucket));
                    double sumLat = GeoShapeCentroidAggregator.this.latSum.get(bucket);
                    double compensationLat = GeoShapeCentroidAggregator.this.latCompensations.get(bucket);
                    double sumLon = GeoShapeCentroidAggregator.this.lonSum.get(bucket);
                    double compensationLon = GeoShapeCentroidAggregator.this.lonCompensations.get(bucket);
                    double sumWeight = GeoShapeCentroidAggregator.this.weightSum.get(bucket);
                    double compensatedWeight = GeoShapeCentroidAggregator.this.weightCompensations.get(bucket);
                    compensatedSumLat.reset(sumLat, compensationLat);
                    compensatedSumLon.reset(sumLon, compensationLon);
                    compensatedSumWeight.reset(sumWeight, compensatedWeight);
                    for (int i = 0; i < valueCount; ++i) {
                        double coordinateWeight;
                        MultiGeoShapeValues.GeoShapeValue value = values.nextValue();
                        int compares = shapeType.compareTo(value.dimensionalShapeType());
                        if (compares < 0) {
                            coordinateWeight = value.weight();
                            compensatedSumLat.reset(coordinateWeight * value.lat(), 0.0);
                            compensatedSumLon.reset(coordinateWeight * value.lon(), 0.0);
                            compensatedSumWeight.reset(coordinateWeight, 0.0);
                            GeoShapeCentroidAggregator.this.dimensionalShapeTypes.set(bucket, (byte)value.dimensionalShapeType().ordinal());
                            continue;
                        }
                        if (compares != 0) continue;
                        coordinateWeight = value.weight();
                        compensatedSumLat.add(coordinateWeight * value.lat());
                        compensatedSumLon.add(coordinateWeight * value.lon());
                        compensatedSumWeight.add(coordinateWeight);
                    }
                    GeoShapeCentroidAggregator.this.lonSum.set(bucket, compensatedSumLon.value());
                    GeoShapeCentroidAggregator.this.lonCompensations.set(bucket, compensatedSumLon.delta());
                    GeoShapeCentroidAggregator.this.latSum.set(bucket, compensatedSumLat.value());
                    GeoShapeCentroidAggregator.this.latCompensations.set(bucket, compensatedSumLat.delta());
                    GeoShapeCentroidAggregator.this.weightSum.set(bucket, compensatedSumWeight.value());
                    GeoShapeCentroidAggregator.this.weightCompensations.set(bucket, compensatedSumWeight.delta());
                }
            }
        };
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        double bucketWeight = this.weightSum.get(bucket);
        GeoPoint bucketCentroid = bucketWeight > 0.0 ? new GeoPoint(this.latSum.get(bucket) / bucketWeight, this.lonSum.get(bucket) / bucketWeight) : null;
        return new InternalGeoCentroid(this.name, bucketCentroid, bucketCount, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoCentroid(this.name, null, 0L, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.latSum, this.latCompensations, this.lonSum, this.lonCompensations, this.counts, this.weightSum, this.weightCompensations, this.dimensionalShapeTypes});
    }
}

