/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.geo.GeoPlugin;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileGridAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregator;
import org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.GeoCentroidAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ValueCountAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.spatial.SpatialFeatureSet;
import org.elasticsearch.xpack.spatial.aggregations.metrics.GeoShapeCentroidAggregator;
import org.elasticsearch.xpack.spatial.index.mapper.GeoShapeWithDocValuesFieldMapper;
import org.elasticsearch.xpack.spatial.index.mapper.PointFieldMapper;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeFieldMapper;
import org.elasticsearch.xpack.spatial.index.query.ShapeQueryBuilder;
import org.elasticsearch.xpack.spatial.ingest.CircleProcessor;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.BoundedGeoHashGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.BoundedGeoTileGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoHashGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellIdSource;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeHashGridAggregator;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeTileGridAggregator;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoTileGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.GeoShapeBoundsAggregator;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSource;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public class SpatialPlugin
extends GeoPlugin
implements MapperPlugin,
SearchPlugin,
IngestPlugin {
    public Collection<Module> createGuiceModules() {
        return Collections.singletonList(b -> XPackPlugin.bindFeatureSet((Binder)b, SpatialFeatureSet.class));
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        HashMap<String, Object> mappers = new HashMap<String, Object>(super.getMappers());
        mappers.put("shape", (Object)new ShapeFieldMapper.TypeParser());
        mappers.put("point", (Object)new PointFieldMapper.TypeParser());
        mappers.put("geo_shape", (Object)new GeoShapeWithDocValuesFieldMapper.TypeParser());
        return Collections.unmodifiableMap(mappers);
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("shape", ShapeQueryBuilder::new, ShapeQueryBuilder::fromXContent));
    }

    public List<Consumer<ValuesSourceRegistry.Builder>> getAggregationExtentions() {
        return org.elasticsearch.common.collect.List.of((Object[])new Consumer[]{this::registerGeoShapeCentroidAggregator, this::registerGeoShapeGridAggregators, SpatialPlugin::registerGeoShapeBoundsAggregator, SpatialPlugin::registerValueCountAggregator, SpatialPlugin::registerCardinalityAggregator});
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return Collections.singletonMap("circle", new CircleProcessor.Factory());
    }

    private static void registerGeoShapeBoundsAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoBoundsAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), GeoShapeBoundsAggregator::new, true);
    }

    private void registerGeoShapeCentroidAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoCentroidAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), (name, valuesSourceConfig, aggregationContext, parent, metadata) -> {
            if (this.getLicenseState().checkFeature(XPackLicenseState.Feature.SPATIAL_GEO_CENTROID)) {
                return new GeoShapeCentroidAggregator(name, aggregationContext, parent, valuesSourceConfig, metadata);
            }
            throw LicenseUtils.newComplianceException((String)"geo_centroid aggregation on geo_shape fields");
        }, true);
    }

    private void registerGeoShapeGridAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoHashGridAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), (name, factories, valuesSource, precision, geoBoundingBox, requiredSize, shardSize, aggregationContext, parent, collectsFromSingleBucket, metadata) -> {
            if (this.getLicenseState().checkFeature(XPackLicenseState.Feature.SPATIAL_GEO_GRID)) {
                GeoHashGridTiler tiler = geoBoundingBox.isUnbounded() ? new GeoHashGridTiler() : new BoundedGeoHashGridTiler(geoBoundingBox);
                GeoShapeCellIdSource cellIdSource = new GeoShapeCellIdSource((GeoShapeValuesSource)valuesSource, precision, tiler);
                GeoShapeHashGridAggregator agg = new GeoShapeHashGridAggregator(name, factories, cellIdSource, requiredSize, shardSize, aggregationContext, parent, collectsFromSingleBucket, metadata);
                cellIdSource.setCircuitBreakerConsumer(agg::addRequestBytes);
                return agg;
            }
            throw LicenseUtils.newComplianceException((String)"geohash_grid aggregation on geo_shape fields");
        }, true);
        builder.register(GeoTileGridAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), (name, factories, valuesSource, precision, geoBoundingBox, requiredSize, shardSize, aggregationContext, parent, collectsFromSingleBucket, metadata) -> {
            if (this.getLicenseState().checkFeature(XPackLicenseState.Feature.SPATIAL_GEO_GRID)) {
                GeoTileGridTiler tiler = geoBoundingBox.isUnbounded() ? new GeoTileGridTiler() : new BoundedGeoTileGridTiler(geoBoundingBox);
                GeoShapeCellIdSource cellIdSource = new GeoShapeCellIdSource((GeoShapeValuesSource)valuesSource, precision, tiler);
                GeoShapeTileGridAggregator agg = new GeoShapeTileGridAggregator(name, factories, cellIdSource, requiredSize, shardSize, aggregationContext, parent, collectsFromSingleBucket, metadata);
                cellIdSource.setCircuitBreakerConsumer(agg::addRequestBytes);
                return agg;
            }
            throw LicenseUtils.newComplianceException((String)"geotile_grid aggregation on geo_shape fields");
        }, true);
    }

    private static void registerValueCountAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register(ValueCountAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), ValueCountAggregator::new, true);
    }

    private static void registerCardinalityAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register(CardinalityAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), CardinalityAggregator::new, true);
    }
}

