/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.topmetrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.sort.SortValue;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregationBuilder;

public class InternalTopMetrics
extends InternalNumericMetricsAggregation.MultiValue {
    private final SortOrder sortOrder;
    private final int size;
    private final List<String> metricNames;
    private final List<TopMetric> topMetrics;

    public InternalTopMetrics(String name, @Nullable SortOrder sortOrder, List<String> metricNames, int size, List<TopMetric> topMetrics, Map<String, Object> metadata) {
        super(name, metadata);
        this.sortOrder = sortOrder;
        this.metricNames = metricNames;
        this.size = size;
        this.topMetrics = topMetrics;
    }

    static InternalTopMetrics buildEmptyAggregation(String name, List<String> metricNames, Map<String, Object> metadata) {
        return new InternalTopMetrics(name, SortOrder.ASC, metricNames, 0, Collections.emptyList(), metadata);
    }

    public InternalTopMetrics(StreamInput in) throws IOException {
        super(in);
        this.sortOrder = SortOrder.readFromStream((StreamInput)in);
        this.metricNames = in.readStringList();
        this.size = in.readVInt();
        this.topMetrics = in.readList(TopMetric::new);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        this.sortOrder.writeTo(out);
        out.writeStringCollection(this.metricNames);
        out.writeVInt(this.size);
        out.writeList(this.topMetrics);
    }

    public String getWriteableName() {
        return "top_metrics";
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() != 1) {
            throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
        }
        int index = this.metricNames.indexOf(path.get(0));
        if (index < 0) {
            throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
        }
        if (this.topMetrics.isEmpty()) {
            return null;
        }
        assert (this.topMetrics.size() == 1) : "property paths should only resolve against top metrics with size == 1.";
        MetricValue metric = (MetricValue)this.topMetrics.get(0).metricValues.get(index);
        if (metric == null) {
            return Double.NaN;
        }
        return metric.numberValue();
    }

    public InternalTopMetrics reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        if (!this.isMapped()) {
            return this;
        }
        ArrayList<TopMetric> merged = new ArrayList<TopMetric>(this.size);
        PriorityQueue<ReduceState> queue = new PriorityQueue<ReduceState>(aggregations.size()){

            protected boolean lessThan(ReduceState lhs, ReduceState rhs) {
                return InternalTopMetrics.this.sortOrder.reverseMul() * lhs.sortValue().compareTo(rhs.sortValue()) < 0;
            }
        };
        for (InternalAggregation agg : aggregations) {
            InternalTopMetrics result = (InternalTopMetrics)agg;
            if (!result.isMapped()) continue;
            queue.add((Object)new ReduceState(result));
        }
        while (queue.size() > 0 && merged.size() < this.size) {
            merged.add(((ReduceState)queue.top()).topMetric());
            ((ReduceState)queue.top()).index++;
            if (((ReduceState)((ReduceState)queue.top())).result.topMetrics.size() <= ((ReduceState)queue.top()).index) {
                queue.pop();
                continue;
            }
            queue.updateTop();
        }
        return new InternalTopMetrics(this.getName(), this.sortOrder, this.metricNames, this.size, merged, this.getMetadata());
    }

    public boolean isMapped() {
        return false == this.topMetrics.isEmpty();
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("top");
        for (TopMetric top : this.topMetrics) {
            top.toXContent(builder, this.metricNames);
        }
        builder.endArray();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sortOrder, this.metricNames, this.size, this.topMetrics);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        InternalTopMetrics other = (InternalTopMetrics)((Object)obj);
        return this.sortOrder.equals((Object)other.sortOrder) && this.metricNames.equals(other.metricNames) && this.size == other.size && this.topMetrics.equals(other.topMetrics);
    }

    public double value(String name) {
        int index = this.metricNames.indexOf(name);
        if (index < 0) {
            throw new IllegalArgumentException("unknown metric [" + name + "]");
        }
        if (this.topMetrics.isEmpty()) {
            return Double.NaN;
        }
        assert (this.topMetrics.size() == 1) : "property paths should only resolve against top metrics with size == 1.";
        return ((MetricValue)this.topMetrics.get(0).metricValues.get(index)).numberValue().doubleValue();
    }

    SortOrder getSortOrder() {
        return this.sortOrder;
    }

    int getSize() {
        return this.size;
    }

    List<String> getMetricNames() {
        return this.metricNames;
    }

    List<TopMetric> getTopMetrics() {
        return this.topMetrics;
    }

    static class MetricValue
    implements Writeable,
    ToXContent {
        private final DocValueFormat format;
        private final SortValue value;

        MetricValue(DocValueFormat format, SortValue value) {
            this.format = format;
            this.value = value;
        }

        DocValueFormat getFormat() {
            return this.format;
        }

        SortValue getValue() {
            return this.value;
        }

        MetricValue(StreamInput in) throws IOException {
            this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
            this.value = (SortValue)in.readNamedWriteable(SortValue.class);
        }

        Number numberValue() {
            return this.value.numberValue();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeNamedWriteable((NamedWriteable)this.format);
            out.writeNamedWriteable((NamedWriteable)this.value);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.value.toXContent(builder, this.format);
        }

        public String toString() {
            return this.format + "," + this.value;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MetricValue other = (MetricValue)obj;
            return this.format.equals(other.format) && this.value.equals((Object)other.value);
        }

        public int hashCode() {
            return Objects.hash(this.format, this.value);
        }
    }

    static class TopMetric
    implements Writeable,
    Comparable<TopMetric> {
        private final DocValueFormat sortFormat;
        private final SortValue sortValue;
        private final List<MetricValue> metricValues;

        TopMetric(DocValueFormat sortFormat, SortValue sortValue, List<MetricValue> metricValues) {
            this.sortFormat = sortFormat;
            this.sortValue = sortValue;
            this.metricValues = metricValues;
        }

        TopMetric(StreamInput in) throws IOException {
            this.sortFormat = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
            this.sortValue = (SortValue)in.readNamedWriteable(SortValue.class);
            this.metricValues = in.readList(s -> (MetricValue)s.readOptionalWriteable(MetricValue::new));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeNamedWriteable((NamedWriteable)this.sortFormat);
            out.writeNamedWriteable((NamedWriteable)this.sortValue);
            out.writeCollection(this.metricValues, StreamOutput::writeOptionalWriteable);
        }

        DocValueFormat getSortFormat() {
            return this.sortFormat;
        }

        SortValue getSortValue() {
            return this.sortValue;
        }

        List<MetricValue> getMetricValues() {
            return this.metricValues;
        }

        public XContentBuilder toXContent(XContentBuilder builder, List<String> metricNames) throws IOException {
            builder.startObject();
            builder.startArray(SearchSourceBuilder.SORT_FIELD.getPreferredName());
            this.sortValue.toXContent(builder, this.sortFormat);
            builder.endArray();
            builder.startObject(TopMetricsAggregationBuilder.METRIC_FIELD.getPreferredName());
            for (int i = 0; i < this.metricValues.size(); ++i) {
                MetricValue value = this.metricValues.get(i);
                builder.field(metricNames.get(i));
                if (value == null) {
                    builder.nullValue();
                    continue;
                }
                value.toXContent(builder, ToXContent.EMPTY_PARAMS);
            }
            builder.endObject();
            return builder.endObject();
        }

        @Override
        public int compareTo(TopMetric o) {
            return this.sortValue.compareTo(o.sortValue);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TopMetric other = (TopMetric)obj;
            return this.sortFormat.equals(other.sortFormat) && this.sortValue.equals((Object)other.sortValue) && this.metricValues.equals(other.metricValues);
        }

        public int hashCode() {
            return Objects.hash(this.sortFormat, this.sortValue, this.metricValues);
        }

        public String toString() {
            return "TopMetric[" + this.sortFormat + "," + this.sortValue + "," + this.metricValues + "]";
        }
    }

    private class ReduceState {
        private final InternalTopMetrics result;
        private int index = 0;

        ReduceState(InternalTopMetrics result) {
            this.result = result;
        }

        SortValue sortValue() {
            return this.topMetric().sortValue;
        }

        TopMetric topMetric() {
            return (TopMetric)this.result.topMetrics.get(this.index);
        }
    }
}

