/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.histogram.SizedBucketAggregator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.rate.InternalRate;

public class RateAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat format;
    private final Rounding.DateTimeUnit rateUnit;
    private final SizedBucketAggregator sizedBucketAggregator;
    private DoubleArray sums;
    private DoubleArray compensations;

    public RateAggregator(String name, ValuesSourceConfig valuesSourceConfig, Rounding.DateTimeUnit rateUnit, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
        this.format = valuesSourceConfig.format();
        if (this.valuesSource != null) {
            this.sums = context.bigArrays().newDoubleArray(1L, true);
            this.compensations = context.bigArrays().newDoubleArray(1L, true);
        }
        this.rateUnit = rateUnit;
        this.sizedBucketAggregator = this.findSizedBucketAncestor();
    }

    private SizedBucketAggregator findSizedBucketAncestor() {
        SizedBucketAggregator sizedBucketAggregator = null;
        for (Aggregator ancestor = this.parent; ancestor != null; ancestor = ancestor.parent()) {
            if (!(ancestor instanceof SizedBucketAggregator)) continue;
            sizedBucketAggregator = (SizedBucketAggregator)ancestor;
            break;
        }
        if (sizedBucketAggregator == null) {
            throw new IllegalArgumentException("The rate aggregation can only be used inside a date histogram");
        }
        return sizedBucketAggregator;
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                RateAggregator.this.sums = bigArrays.grow(RateAggregator.this.sums, bucket + 1L);
                RateAggregator.this.compensations = bigArrays.grow(RateAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    double sum = RateAggregator.this.sums.get(bucket);
                    double compensation = RateAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        kahanSummation.add(value);
                    }
                    RateAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    RateAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (this.sizedBucketAggregator == null || this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd) / this.sizedBucketAggregator.bucketSize(owningBucketOrd, this.rateUnit);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalRate(this.name, this.sums.get(bucket), this.sizedBucketAggregator.bucketSize(bucket, this.rateUnit), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalRate(this.name, 0.0, 1.0, this.format, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sums, this.compensations});
    }
}

