/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalMax;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

public class HistoBackedMaxAggregator
extends NumericMetricsAggregator.SingleValue {
    private final HistogramValuesSource.Histogram valuesSource;
    final DocValueFormat formatter;
    DoubleArray maxes;

    public HistoBackedMaxAggregator(String name, ValuesSourceConfig config, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        HistogramValuesSource.Histogram histogram = this.valuesSource = config.hasValues() ? (HistogramValuesSource.Histogram)config.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.maxes = context.bigArrays().newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
        this.formatter = config.format();
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            if (this.parent != null) {
                return LeafBucketCollector.NO_OP_COLLECTOR;
            }
            throw new CollectionTerminatedException();
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final HistogramValues values = this.valuesSource.getHistogramValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= HistoBackedMaxAggregator.this.maxes.size()) {
                    long from = HistoBackedMaxAggregator.this.maxes.size();
                    HistoBackedMaxAggregator.this.maxes = bigArrays.grow(HistoBackedMaxAggregator.this.maxes, bucket + 1L);
                    HistoBackedMaxAggregator.this.maxes.fill(from, HistoBackedMaxAggregator.this.maxes.size(), Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    while (sketch.next()) {
                        double value = sketch.value();
                        double max = HistoBackedMaxAggregator.this.maxes.get(bucket);
                        max = Math.max(max, value);
                        HistoBackedMaxAggregator.this.maxes.set(bucket, max);
                    }
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.maxes.size()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.maxes.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.maxes.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMax(this.name, this.maxes.get(bucket), this.formatter, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMax(this.name, Double.NEGATIVE_INFINITY, this.formatter, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable)this.maxes);
    }
}

