/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.histogram.AbstractHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

public class HistoBackedHistogramAggregator
extends AbstractHistogramAggregator {
    private final HistogramValuesSource.Histogram valuesSource;

    public HistoBackedHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, CardinalityUpperBound cardinalityUpperBound, Map<String, Object> metadata) throws IOException {
        super(name, factories, interval, offset, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig.format(), context, parent, cardinalityUpperBound, metadata);
        HistogramValuesSource.Histogram histogram = this.valuesSource = valuesSourceConfig.hasValues() ? (HistogramValuesSource.Histogram)valuesSourceConfig.getValuesSource() : null;
        if (this.subAggregators().length > 0) {
            throw new IllegalArgumentException("Histogram aggregation on histogram fields does not support sub-aggregations");
        }
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final HistogramValues values = this.valuesSource.getHistogramValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    double previousKey = Double.NEGATIVE_INFINITY;
                    while (sketch.next()) {
                        double value = sketch.value();
                        int count = sketch.count();
                        double key = Math.floor((value - HistoBackedHistogramAggregator.this.offset) / HistoBackedHistogramAggregator.this.interval);
                        assert (key >= previousKey);
                        long bucketOrd = HistoBackedHistogramAggregator.this.bucketOrds.add(owningBucketOrd, Double.doubleToLongBits(key));
                        if (bucketOrd < 0L) {
                            bucketOrd = -1L - bucketOrd;
                            HistoBackedHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                        } else {
                            HistoBackedHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                        }
                        HistoBackedHistogramAggregator.this.incrementBucketDocCount(bucketOrd, count - 1);
                        previousKey = key;
                    }
                }
            }
        };
    }
}

