/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.analytics.AnalyticsFeatureSetUsage;
import org.elasticsearch.xpack.core.analytics.action.AnalyticsStatsAction;

public class AnalyticsFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;
    private Client client;

    @Inject
    public AnalyticsFeatureSet(@Nullable XPackLicenseState licenseState, Client client) {
        this.licenseState = licenseState;
        this.client = client;
    }

    public String name() {
        return "analytics";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isAllowed(XPackLicenseState.Feature.ANALYTICS);
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        AnalyticsStatsAction.Request request = new AnalyticsStatsAction.Request();
        this.client.execute((ActionType)AnalyticsStatsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> listener.onResponse((Object)new AnalyticsFeatureSetUsage(this.available(), this.enabled(), r)), arg_0 -> listener.onFailure(arg_0)));
    }
}

