/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.InternalStats;

public class InternalExtendedStats
extends InternalStats
implements ExtendedStats {
    private final double sumOfSqrs;
    private final double sigma;

    public InternalExtendedStats(String name, long count, double sum, double min, double max, double sumOfSqrs, double sigma, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, count, sum, min, max, formatter, metadata);
        this.sumOfSqrs = sumOfSqrs;
        this.sigma = sigma;
    }

    public InternalExtendedStats(StreamInput in) throws IOException {
        super(in);
        this.sumOfSqrs = in.readDouble();
        this.sigma = in.readDouble();
    }

    @Override
    protected void writeOtherStatsTo(StreamOutput out) throws IOException {
        out.writeDouble(this.sumOfSqrs);
        out.writeDouble(this.sigma);
    }

    @Override
    public String getWriteableName() {
        return "extended_stats";
    }

    @Override
    public double value(String name) {
        if ("sum_of_squares".equals(name)) {
            return this.sumOfSqrs;
        }
        if ("variance".equals(name)) {
            return this.getVariance();
        }
        if ("variance_population".equals(name)) {
            return this.getVariancePopulation();
        }
        if ("variance_sampling".equals(name)) {
            return this.getVarianceSampling();
        }
        if ("std_deviation".equals(name)) {
            return this.getStdDeviation();
        }
        if ("std_deviation_population".equals(name)) {
            return this.getStdDeviationPopulation();
        }
        if ("std_deviation_sampling".equals(name)) {
            return this.getStdDeviationSampling();
        }
        if ("std_upper".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.UPPER);
        }
        if ("std_lower".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.LOWER);
        }
        if ("std_upper_population".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_POPULATION);
        }
        if ("std_lower_population".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_POPULATION);
        }
        if ("std_upper_sampling".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_SAMPLING);
        }
        if ("std_lower_sampling".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_SAMPLING);
        }
        return super.value(name);
    }

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSqrs;
    }

    @Override
    public double getVariance() {
        return this.getVariancePopulation();
    }

    @Override
    public double getVariancePopulation() {
        double variance = (this.sumOfSqrs - this.sum * this.sum / (double)this.count) / (double)this.count;
        return variance < 0.0 ? 0.0 : variance;
    }

    @Override
    public double getVarianceSampling() {
        double variance = (this.sumOfSqrs - this.sum * this.sum / (double)this.count) / (double)(this.count - 1L);
        return variance < 0.0 ? 0.0 : variance;
    }

    @Override
    public double getStdDeviation() {
        return this.getStdDeviationPopulation();
    }

    @Override
    public double getStdDeviationPopulation() {
        return Math.sqrt(this.getVariancePopulation());
    }

    @Override
    public double getStdDeviationSampling() {
        return Math.sqrt(this.getVarianceSampling());
    }

    @Override
    public double getStdDeviationBound(ExtendedStats.Bounds bound) {
        switch (bound) {
            case UPPER: 
            case UPPER_POPULATION: {
                return this.getAvg() + this.getStdDeviationPopulation() * this.sigma;
            }
            case UPPER_SAMPLING: {
                return this.getAvg() + this.getStdDeviationSampling() * this.sigma;
            }
            case LOWER: 
            case LOWER_POPULATION: {
                return this.getAvg() - this.getStdDeviationPopulation() * this.sigma;
            }
            case LOWER_SAMPLING: {
                return this.getAvg() - this.getStdDeviationSampling() * this.sigma;
            }
        }
        throw new IllegalArgumentException("Unknown bounds type " + (Object)((Object)bound));
    }

    @Override
    public String getSumOfSquaresAsString() {
        return this.valueAsString(Metrics.sum_of_squares.name());
    }

    @Override
    public String getVarianceAsString() {
        return this.valueAsString(Metrics.variance.name());
    }

    @Override
    public String getVariancePopulationAsString() {
        return this.valueAsString(Metrics.variance_population.name());
    }

    @Override
    public String getVarianceSamplingAsString() {
        return this.valueAsString(Metrics.variance_sampling.name());
    }

    @Override
    public String getStdDeviationAsString() {
        return this.valueAsString(Metrics.std_deviation.name());
    }

    @Override
    public String getStdDeviationPopulationAsString() {
        return this.valueAsString(Metrics.std_deviation_population.name());
    }

    @Override
    public String getStdDeviationSamplingAsString() {
        return this.valueAsString(Metrics.std_deviation_sampling.name());
    }

    @Override
    public String getStdDeviationBoundAsString(ExtendedStats.Bounds bound) {
        switch (bound) {
            case UPPER: {
                return this.valueAsString(Metrics.std_upper.name());
            }
            case LOWER: {
                return this.valueAsString(Metrics.std_lower.name());
            }
            case UPPER_POPULATION: {
                return this.valueAsString(Metrics.std_upper_population.name());
            }
            case LOWER_POPULATION: {
                return this.valueAsString(Metrics.std_lower_population.name());
            }
            case UPPER_SAMPLING: {
                return this.valueAsString(Metrics.std_upper_sampling.name());
            }
            case LOWER_SAMPLING: {
                return this.valueAsString(Metrics.std_lower_sampling.name());
            }
        }
        throw new IllegalArgumentException("Unknown bounds type " + (Object)((Object)bound));
    }

    @Override
    public InternalExtendedStats reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double sumOfSqrs = 0.0;
        double compensationOfSqrs = 0.0;
        for (InternalAggregation aggregation : aggregations) {
            InternalExtendedStats stats = (InternalExtendedStats)aggregation;
            if (stats.sigma != this.sigma) {
                throw new IllegalStateException("Cannot reduce other stats aggregations that have a different sigma");
            }
            double value = stats.getSumOfSquares();
            if (!Double.isFinite(value)) {
                sumOfSqrs += value;
                continue;
            }
            if (!Double.isFinite(sumOfSqrs)) continue;
            double correctedOfSqrs = value - compensationOfSqrs;
            double newSumOfSqrs = sumOfSqrs + correctedOfSqrs;
            compensationOfSqrs = newSumOfSqrs - sumOfSqrs - correctedOfSqrs;
            sumOfSqrs = newSumOfSqrs;
        }
        InternalAggregation stats = super.reduce((List)aggregations, reduceContext);
        return new InternalExtendedStats(this.name, ((InternalStats)stats).getCount(), ((InternalStats)stats).getSum(), ((InternalStats)stats).getMin(), ((InternalStats)stats).getMax(), sumOfSqrs, this.sigma, this.format, this.getMetadata());
    }

    @Override
    protected XContentBuilder otherStatsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.count != 0L) {
            builder.field("sum_of_squares", this.sumOfSqrs);
            builder.field("variance", this.getVariance());
            builder.field("variance_population", this.getVariancePopulation());
            builder.field("variance_sampling", this.getVarianceSampling());
            builder.field("std_deviation", this.getStdDeviation());
            builder.field("std_deviation_population", this.getStdDeviationPopulation());
            builder.field("std_deviation_sampling", this.getStdDeviationSampling());
            builder.startObject("std_deviation_bounds");
            builder.field("upper", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER));
            builder.field("lower", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER));
            builder.field("upper_population", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_POPULATION));
            builder.field("lower_population", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_POPULATION));
            builder.field("upper_sampling", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_SAMPLING));
            builder.field("lower_sampling", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_SAMPLING));
            builder.endObject();
            if (this.format != DocValueFormat.RAW) {
                builder.field("sum_of_squares_as_string", this.format.format(this.sumOfSqrs));
                builder.field("variance_as_string", this.format.format(this.getVariance()));
                builder.field("variance_population_as_string", this.format.format(this.getVariancePopulation()));
                builder.field("variance_sampling_as_string", this.format.format(this.getVarianceSampling()));
                builder.field("std_deviation_as_string", this.getStdDeviationAsString());
                builder.field("std_deviation_population_as_string", this.getStdDeviationPopulationAsString());
                builder.field("std_deviation_sampling_as_string", this.getStdDeviationSamplingAsString());
                builder.startObject("std_deviation_bounds_as_string");
                builder.field("upper", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER));
                builder.field("lower", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER));
                builder.field("upper_population", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER_POPULATION));
                builder.field("lower_population", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER_POPULATION));
                builder.field("upper_sampling", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER_SAMPLING));
                builder.field("lower_sampling", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER_SAMPLING));
                builder.endObject();
            }
        } else {
            builder.nullField("sum_of_squares");
            builder.nullField("variance");
            builder.nullField("variance_population");
            builder.nullField("variance_sampling");
            builder.nullField("std_deviation");
            builder.nullField("std_deviation_population");
            builder.nullField("std_deviation_sampling");
            builder.startObject("std_deviation_bounds");
            builder.nullField("upper");
            builder.nullField("lower");
            builder.nullField("upper_population");
            builder.nullField("lower_population");
            builder.nullField("upper_sampling");
            builder.nullField("lower_sampling");
            builder.endObject();
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sumOfSqrs, this.sigma);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalExtendedStats other = (InternalExtendedStats)obj;
        return Double.compare(this.sumOfSqrs, other.sumOfSqrs) == 0 && Double.compare(this.sigma, other.sigma) == 0;
    }

    static class Fields {
        public static final String SUM_OF_SQRS = "sum_of_squares";
        public static final String SUM_OF_SQRS_AS_STRING = "sum_of_squares_as_string";
        public static final String VARIANCE = "variance";
        public static final String VARIANCE_AS_STRING = "variance_as_string";
        public static final String VARIANCE_POPULATION = "variance_population";
        public static final String VARIANCE_POPULATION_AS_STRING = "variance_population_as_string";
        public static final String VARIANCE_SAMPLING = "variance_sampling";
        public static final String VARIANCE_SAMPLING_AS_STRING = "variance_sampling_as_string";
        public static final String STD_DEVIATION = "std_deviation";
        public static final String STD_DEVIATION_AS_STRING = "std_deviation_as_string";
        public static final String STD_DEVIATION_POPULATION = "std_deviation_population";
        public static final String STD_DEVIATION_POPULATION_AS_STRING = "std_deviation_population_as_string";
        public static final String STD_DEVIATION_SAMPLING = "std_deviation_sampling";
        public static final String STD_DEVIATION_SAMPLING_AS_STRING = "std_deviation_sampling_as_string";
        public static final String STD_DEVIATION_BOUNDS = "std_deviation_bounds";
        public static final String STD_DEVIATION_BOUNDS_AS_STRING = "std_deviation_bounds_as_string";
        public static final String UPPER = "upper";
        public static final String LOWER = "lower";
        public static final String UPPER_POPULATION = "upper_population";
        public static final String LOWER_POPULATION = "lower_population";
        public static final String UPPER_SAMPLING = "upper_sampling";
        public static final String LOWER_SAMPLING = "lower_sampling";

        Fields() {
        }
    }

    static enum Metrics {
        count,
        sum,
        min,
        max,
        avg,
        sum_of_squares,
        variance,
        variance_population,
        variance_sampling,
        std_deviation,
        std_deviation_population,
        std_deviation_sampling,
        std_upper,
        std_lower,
        std_upper_population,
        std_lower_population,
        std_upper_sampling,
        std_lower_sampling;


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name);
        }
    }
}

