/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class PipelineAggregationBuilder
implements NamedWriteable,
BaseAggregationBuilder,
ToXContentFragment,
Rewriteable<PipelineAggregationBuilder> {
    protected final String name;
    protected final String[] bucketsPaths;

    protected PipelineAggregationBuilder(String name, String[] bucketsPaths) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null: [" + name + "]");
        }
        if (bucketsPaths == null) {
            throw new IllegalArgumentException("[bucketsPaths] must not be null: [" + name + "]");
        }
        this.name = name;
        this.bucketsPaths = bucketsPaths;
    }

    public String getName() {
        return this.name;
    }

    public final String[] getBucketsPaths() {
        return this.bucketsPaths;
    }

    protected abstract void validate(ValidationContext var1);

    protected abstract PipelineAggregator create();

    @Override
    public abstract PipelineAggregationBuilder setMetadata(Map<String, Object> var1);

    @Override
    public PipelineAggregationBuilder subAggregations(AggregatorFactories.Builder subFactories) {
        throw new IllegalArgumentException("Aggregation [" + this.name + "] cannot define sub-aggregations");
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    @Override
    public PipelineAggregationBuilder rewrite(QueryRewriteContext context) throws IOException {
        return this;
    }

    public static abstract class ValidationContext {
        private ActionRequestValidationException e;

        public static ValidationContext forTreeRoot(Collection<AggregationBuilder> siblingAggregations, Collection<PipelineAggregationBuilder> siblingPipelineAggregations, ActionRequestValidationException validationFailuresSoFar) {
            return new ForTreeRoot(siblingAggregations, siblingPipelineAggregations, validationFailuresSoFar);
        }

        public static ValidationContext forInsideTree(AggregationBuilder parent, ActionRequestValidationException validationFailuresSoFar) {
            return new ForInsideTree(parent, validationFailuresSoFar);
        }

        private ValidationContext(ActionRequestValidationException validationFailuresSoFar) {
            this.e = validationFailuresSoFar;
        }

        public abstract Collection<AggregationBuilder> getSiblingAggregations();

        public abstract Collection<PipelineAggregationBuilder> getSiblingPipelineAggregations();

        public void addValidationError(String error) {
            this.e = ValidateActions.addValidationError(error, this.e);
        }

        public void addBucketPathValidationError(String error) {
            this.addValidationError(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + ' ' + error);
        }

        public abstract void validateHasParent(String var1, String var2);

        public abstract void validateParentAggSequentiallyOrdered(String var1, String var2);

        public ActionRequestValidationException getValidationException() {
            return this.e;
        }

        private static class ForInsideTree
        extends ValidationContext {
            private final AggregationBuilder parent;

            ForInsideTree(AggregationBuilder parent, ActionRequestValidationException validationFailuresSoFar) {
                super(validationFailuresSoFar);
                this.parent = Objects.requireNonNull(parent);
            }

            @Override
            public Collection<AggregationBuilder> getSiblingAggregations() {
                return this.parent.getSubAggregations();
            }

            @Override
            public Collection<PipelineAggregationBuilder> getSiblingPipelineAggregations() {
                return this.parent.getPipelineAggregations();
            }

            @Override
            public void validateHasParent(String type, String name) {
            }

            @Override
            public void validateParentAggSequentiallyOrdered(String type, String name) {
                if (this.parent instanceof HistogramAggregationBuilder) {
                    HistogramAggregationBuilder histoParent = (HistogramAggregationBuilder)this.parent;
                    if (histoParent.minDocCount() != 0L) {
                        this.addValidationError("parent histogram of " + type + " aggregation [" + name + "] must have min_doc_count of 0");
                    }
                } else if (this.parent instanceof DateHistogramAggregationBuilder) {
                    DateHistogramAggregationBuilder histoParent = (DateHistogramAggregationBuilder)this.parent;
                    if (histoParent.minDocCount() != 0L) {
                        this.addValidationError("parent histogram of " + type + " aggregation [" + name + "] must have min_doc_count of 0");
                    }
                } else if (!(this.parent instanceof AutoDateHistogramAggregationBuilder)) {
                    this.addValidationError(type + " aggregation [" + name + "] must have a histogram, date_histogram or auto_date_histogram as parent");
                }
            }
        }

        private static class ForTreeRoot
        extends ValidationContext {
            private final Collection<AggregationBuilder> siblingAggregations;
            private final Collection<PipelineAggregationBuilder> siblingPipelineAggregations;

            ForTreeRoot(Collection<AggregationBuilder> siblingAggregations, Collection<PipelineAggregationBuilder> siblingPipelineAggregations, ActionRequestValidationException validationFailuresSoFar) {
                super(validationFailuresSoFar);
                this.siblingAggregations = Objects.requireNonNull(siblingAggregations);
                this.siblingPipelineAggregations = Objects.requireNonNull(siblingPipelineAggregations);
            }

            @Override
            public Collection<AggregationBuilder> getSiblingAggregations() {
                return this.siblingAggregations;
            }

            @Override
            public Collection<PipelineAggregationBuilder> getSiblingPipelineAggregations() {
                return this.siblingPipelineAggregations;
            }

            @Override
            public void validateHasParent(String type, String name) {
                this.addValidationError(type + " aggregation [" + name + "] must be declared inside of another aggregation");
            }

            @Override
            public void validateParentAggSequentiallyOrdered(String type, String name) {
                this.addValidationError(type + " aggregation [" + name + "] must have a histogram, date_histogram or auto_date_histogram as parent but doesn't have a parent");
            }
        }
    }
}

