/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.NodePersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;

public class PersistentTasksNodeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(PersistentTasksNodeService.class);
    private final Map<Long, AllocatedPersistentTask> runningTasks = new HashMap<Long, AllocatedPersistentTask>();
    private final PersistentTasksService persistentTasksService;
    private final PersistentTasksExecutorRegistry persistentTasksExecutorRegistry;
    private final TaskManager taskManager;
    private final NodePersistentTasksExecutor nodePersistentTasksExecutor;

    public PersistentTasksNodeService(PersistentTasksService persistentTasksService, PersistentTasksExecutorRegistry persistentTasksExecutorRegistry, TaskManager taskManager, NodePersistentTasksExecutor nodePersistentTasksExecutor) {
        this.persistentTasksService = persistentTasksService;
        this.persistentTasksExecutorRegistry = persistentTasksExecutorRegistry;
        this.taskManager = taskManager;
        this.nodePersistentTasksExecutor = nodePersistentTasksExecutor;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        PersistentTasksCustomMetadata previousTasks;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)event.state().getMetadata().custom("persistent_tasks");
        if (!Objects.equals(tasks, previousTasks = (PersistentTasksCustomMetadata)event.previousState().getMetadata().custom("persistent_tasks")) || event.nodesChanged()) {
            String localNodeId = event.state().getNodes().getLocalNodeId();
            HashSet<Long> notVisitedTasks = new HashSet<Long>(this.runningTasks.keySet());
            if (tasks != null) {
                for (PersistentTasksCustomMetadata.PersistentTask persistentTask : tasks.tasks()) {
                    if (!localNodeId.equals(persistentTask.getExecutorNode())) continue;
                    Long allocationId = persistentTask.getAllocationId();
                    AllocatedPersistentTask persistentTask2 = this.runningTasks.get(allocationId);
                    if (persistentTask2 == null) {
                        try {
                            this.startTask(persistentTask);
                        }
                        catch (Exception e) {
                            logger.error("Unable to start allocated task [" + persistentTask.getTaskName() + "] with id [" + persistentTask.getId() + "] and allocation id [" + persistentTask.getAllocationId() + "]", (Throwable)e);
                        }
                        continue;
                    }
                    notVisitedTasks.remove(allocationId);
                }
            }
            for (Long l : notVisitedTasks) {
                AllocatedPersistentTask task = this.runningTasks.get(l);
                if (task.isCompleted()) {
                    logger.trace("Found completed persistent task [{}] with id [{}] and allocation id [{}] - removing", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                    this.runningTasks.remove(l);
                    continue;
                }
                logger.trace("Found unregistered persistent task [{}] with id [{}] and allocation id [{}] - cancelling", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.cancelTask(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Params extends PersistentTaskParams> void startTask(final PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress) {
        AllocatedPersistentTask task;
        final PersistentTasksExecutor executor = this.persistentTasksExecutorRegistry.getPersistentTaskExecutorSafe(taskInProgress.getTaskName());
        TaskAwareRequest request = new TaskAwareRequest(){
            TaskId parentTaskId;
            {
                this.parentTaskId = new TaskId("cluster", taskInProgress.getAllocationId());
            }

            @Override
            public void setParentTask(TaskId taskId) {
                throw new UnsupportedOperationException("parent task if for persistent tasks shouldn't change");
            }

            @Override
            public TaskId getParentTask() {
                return this.parentTaskId;
            }

            @Override
            public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
                return executor.createTask(id, type, action, parentTaskId, taskInProgress, headers);
            }
        };
        try {
            task = (AllocatedPersistentTask)this.taskManager.register("persistent", taskInProgress.getTaskName() + "[c]", request);
        }
        catch (Exception e) {
            logger.error("Fatal error registering persistent task [" + taskInProgress.getTaskName() + "] with id [" + taskInProgress.getId() + "] and allocation id [" + taskInProgress.getAllocationId() + "], removing from persistent tasks", (Throwable)e);
            this.notifyMasterOfFailedTask(taskInProgress, e);
            return;
        }
        boolean processed = false;
        try {
            task.init(this.persistentTasksService, this.taskManager, taskInProgress.getId(), taskInProgress.getAllocationId());
            logger.trace("Persistent task [{}] with id [{}] and allocation id [{}] was created", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
            try {
                this.runningTasks.put(taskInProgress.getAllocationId(), task);
                this.nodePersistentTasksExecutor.executeTask(taskInProgress.getParams(), taskInProgress.getState(), task, executor);
            }
            catch (Exception e) {
                task.markAsFailed(e);
            }
            processed = true;
        }
        finally {
            if (!processed) {
                logger.warn("Persistent task [{}] with id [{}] and allocation id [{}] failed to create", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.taskManager.unregister(task);
            }
        }
    }

    private <Params extends PersistentTaskParams> void notifyMasterOfFailedTask(final PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress, final Exception originalException) {
        this.persistentTasksService.sendCompletionRequest(taskInProgress.getId(), taskInProgress.getAllocationId(), originalException, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

            @Override
            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
                logger.trace("completion notification for failed task [{}] with id [{}] was successful", (Object)taskInProgress.getTaskName(), (Object)taskInProgress.getAllocationId());
            }

            @Override
            public void onFailure(Exception notificationException) {
                notificationException.addSuppressed(originalException);
                logger.warn(new ParameterizedMessage("notification for task [{}] with id [{}] failed", (Object)taskInProgress.getTaskName(), (Object)taskInProgress.getAllocationId()), (Throwable)notificationException);
            }
        });
    }

    private void cancelTask(Long allocationId) {
        final AllocatedPersistentTask task = this.runningTasks.remove(allocationId);
        if (task.markAsCancelled()) {
            String reason = "task has been removed, cancelling locally";
            this.persistentTasksService.sendCancelRequest(task.getId(), reason, new ActionListener<CancelTasksResponse>(){

                @Override
                public void onResponse(CancelTasksResponse cancelTasksResponse) {
                    logger.trace("Persistent task [{}] with id [{}] and allocation id [{}] was cancelled", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn(() -> new ParameterizedMessage("failed to cancel task [{}] with id [{}] and allocation id [{}]", task.getAction(), task.getPersistentTaskId(), task.getAllocationId()), (Throwable)e);
                }
            });
        }
    }

    public static class Status
    implements Task.Status {
        public static final String NAME = "persistent_executor";
        private final AllocatedPersistentTask.State state;

        public Status(AllocatedPersistentTask.State state) {
            this.state = Objects.requireNonNull(state, "State cannot be null");
        }

        public Status(StreamInput in) throws IOException {
            this.state = AllocatedPersistentTask.State.valueOf(in.readString());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("state", this.state.toString());
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.state.toString());
        }

        public String toString() {
            return Strings.toString(this);
        }

        @Override
        public boolean isFragment() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.state == status.state;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state});
        }
    }
}

